<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paymaxMerchantCallbackByParams(array $params)
 * @method newMerchantByParams(array $params)
 * @method changeMerchantByParams(array $params)
 * @method listMerchantByParams(array $params)
 */
class PayMax {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拉卡拉审核回调
     *
     * @param  string $contractId 进件ID [ require true ]
     * @param  string $shopNo 拉卡拉商铺ID [ require true ]
     * @param  string $termNos 拉卡拉终端号 [ require true ]
     * @param  string $contractStatus 审核状态 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function paymaxMerchantCallback (string $contractId, string $shopNo, string $termNos, string $contractStatus) {
        return self::getClass()->paymaxMerchantCallback([
            "contractId" => $contractId,
            "shopNo" => $shopNo,
            "termNos" => $termNos,
            "contractStatus" => $contractStatus,
        ]);
    }

    /**
     * 拉卡拉进件
     *
     * @param  string $wechatAppId 微信公众号APPID [ require true ]
     * @param  array $info 进件信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newMerchant (string $wechatAppId, array $info) {
        return self::getClass()->newMerchant([
            "wechatAppId" => $wechatAppId,
            "info" => $info,
        ]);
    }

    /**
     * 拉卡拉修改进件信息
     *
     * @param  string $wechatAppId 微信公众号APPID [ require true ]
     * @param  int $merchantId 商户ID [Original type uint] [ require true ]
     * @param  array $info 进件信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeMerchant (int $merchantId, string $wechatAppId, array $info) {
        return self::getClass()->changeMerchant([
            "merchantId" => $merchantId,
            "wechatAppId" => $wechatAppId,
            "info" => $info,
        ]);
    }

    /**
     * 拉卡拉进件列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $num 每页数目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listMerchant (int $page = 1, int $num = 10) {
        return self::getClass()->listMerchant([
            "page" => $page,
            "num" => $num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'PayMax');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'PayMax');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}