<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkOrderByIdByParams(array $params)
 * @method showViewByParams(array $params)
 * @method returnWechatViewByParams(array $params)
 * @method orderQueryByParams(array $params)
 */
class Alipay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据refundNum确认支付宝退款信息
     *
     * @param  string $paymentId 订单号 [ require true ]
     * @param  string $refundNum 退款号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderById (string $paymentId, string $refundNum) {
        return self::getClass()->checkOrderById([
            "paymentId" => $paymentId,
            "refundNum" => $refundNum,
        ]);
    }

    /**
     * 支付宝跳转页面
     *
     * @param  string $url 回调地址 [ require true ]
     * @param  string $reqUrl 请求地址 [ require true ]
     * @param  string $code 支付码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showView (string $url, string $reqUrl, string $code) {
        return self::getClass()->showView([
            "url" => $url,
            "reqUrl" => $reqUrl,
            "code" => $code,
        ]);
    }

    /**
     * 支付成功页面
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnWechatView () {
        return self::getClass()->returnWechatView();
    }

    /**
     * 查询账单
     *
     * @param  string $subInstId 子商户id [ require true ]
     * @param  string $billDate 对账单日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderQuery (string $subInstId, string $billDate) {
        return self::getClass()->orderQuery([
            "subInstId" => $subInstId,
            "billDate" => $billDate,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Alipay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Alipay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}