<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initStoreByParams(array $params)
 * @method initAlipayPublicCertByParams(array $params)
 * @method showMerchantByPageByParams(array $params)
 * @method showMerchantInfoByParams(array $params)
 * @method updateMerchantInfoByParams(array $params)
 * @method downMerchantByParams(array $params)
 * @method upMerchantByParams(array $params)
 */
class Merchant {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 初始化支付宝签约门店
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @param  string $wechatAppId 微信APPID [ require true ]
     * @param  string $alipayAppId 支付宝APPID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function initStore (string $subInstId, string $wechatAppId = NULL, string $alipayAppId = NULL) {
        return self::getClass()->initStore([
            "subInstId" => $subInstId,
            "wechatAppId" => $wechatAppId,
            "alipayAppId" => $alipayAppId,
        ]);
    }

    /**
     * 更新支付宝证书
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @param  string $alipayPublicKey 支付宝public证书 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initAlipayPublicCert (string $subInstId, string $alipayPublicKey) {
        return self::getClass()->initAlipayPublicCert([
            "subInstId" => $subInstId,
            "alipayPublicKey" => $alipayPublicKey,
        ]);
    }

    /**
     * 显示门店信息
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $num 每页数目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function showMerchantByPage (int $page = 1, int $num = 10) {
        return self::getClass()->showMerchantByPage([
            "page" => $page,
            "num" => $num,
        ]);
    }

    /**
     * 显示门店信息
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function showMerchantInfo (string $subInstId) {
        return self::getClass()->showMerchantInfo([
            "subInstId" => $subInstId,
        ]);
    }

    /**
     * 更新门店信息
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @param  string $info 更新的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMerchantInfo (string $subInstId, string $info) {
        return self::getClass()->updateMerchantInfo([
            "subInstId" => $subInstId,
            "info" => $info,
        ]);
    }

    /**
     * 下线商户
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downMerchant (string $subInstId) {
        return self::getClass()->downMerchant([
            "subInstId" => $subInstId,
        ]);
    }

    /**
     * 上线商户
     *
     * @param  string $subInstId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upMerchant (string $subInstId) {
        return self::getClass()->upMerchant([
            "subInstId" => $subInstId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Merchant');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Merchant');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}