<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNewPaymentByParams(array $params)
 * @method paymentByParams(array $params)
 * @method checkOrderByPaymentStrByParams(array $params)
 * @method checkOrderByPaymentIDByParams(array $params)
 * @method paymentICBCWechatNotifyByParams(array $params)
 * @method paymentWechatNotifyByParams(array $params)
 * @method paymentAlipayNotifyByParams(array $params)
 * @method closeOrderByPaymentIDByParams(array $params)
 * @method closeOrderByOrderIdByParams(array $params)
 * @method refundByPaymentIDByParams(array $params)
 * @method showRefundByPaymentIdByParams(array $params)
 * @method checkPaymentCronByParams(array $params)
 */
class Payment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建支付单
     *
     * @param  string $orderId 原始订单ID [ require true ]
     * @param  string $subMchId 子商户ID [ require true ]
     * @param  float $needPayment 需要支付的金额(单位为元) [Original type unsignedDouble] [ require true ]
     * @param  int $expiredTime 过期时间 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewPayment (string $orderId, string $subMchId, float $needPayment, int $expiredTime = 3600, array $extend = []) {
        return self::getClass()->addNewPayment([
            "orderId" => $orderId,
            "subMchId" => $subMchId,
            "needPayment" => $needPayment,
            "expiredTime" => $expiredTime,
            "extend" => $extend,
        ]);
    }

    /**
     * 申请支付
     *
     * @param  string $paymentStr 加密后的支付信息 [ require true ]
     * @param  string $paymentType 支付类型(ICBCWechat: 工商微信支付, Alipay: 支付宝支付, Wechat: 微信支付) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function payment (string $paymentStr, string $paymentType) {
        return self::getClass()->payment([
            "paymentStr" => $paymentStr,
            "paymentType" => $paymentType,
        ]);
    }

    /**
     * 根据支付信息检查订单状态
     *
     * @param  string $paymentStr 加密后的支付信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderByPaymentStr (string $paymentStr) {
        return self::getClass()->checkOrderByPaymentStr([
            "paymentStr" => $paymentStr,
        ]);
    }

    /**
     * 根据支付ID检查订单状态
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderByPaymentID (string $paymentId) {
        return self::getClass()->checkOrderByPaymentID([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 工行微信回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function paymentICBCWechatNotify () {
        return self::getClass()->paymentICBCWechatNotify();
    }

    /**
     * 原始微信回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function paymentWechatNotify () {
        return self::getClass()->paymentWechatNotify();
    }

    /**
     * 支付宝回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function paymentAlipayNotify () {
        return self::getClass()->paymentAlipayNotify();
    }

    /**
     * 根据支付ID关闭订单
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderByPaymentID (string $paymentId) {
        return self::getClass()->closeOrderByPaymentID([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 根据订单号关闭订单
     *
     * @param  string $orderId 商户原始订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderByOrderId (string $orderId) {
        return self::getClass()->closeOrderByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据支付ID退款
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @param  float $refundAmount 退款金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundByPaymentID (string $paymentId, float $refundAmount) {
        return self::getClass()->refundByPaymentID([
            "paymentId" => $paymentId,
            "refundAmount" => $refundAmount,
        ]);
    }

    /**
     * 查询退款日志
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showRefundByPaymentId (string $paymentId) {
        return self::getClass()->showRefundByPaymentId([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 每10分钟查询一次是否支付成功
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkPaymentCron () {
        return self::getClass()->checkPaymentCron();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Payment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Payment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}