<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-27 16:59:29
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderUpgrade
 * @method getOrderSalesByParams(array $params) 获取订单中的拍摄主产品
 * @method createUpgradeSkuByParams(array $params) 完成订单之后添加升级服务产品
 * @method serviceCompleteByParams(array $params) 服务完成
 * @method setLookPhotoCompleteByParams(array $params) 设置看片完成
 * @method clearLookPhotoCompletedAtByParams(array $params) 看片完成标记清除
 * @method getUpgradeSkuListByParams(array $params) 获取订单升级服务的产品列表
 * @method setPhotoFinishedAtByParams(array $params) 设置照片交付时间
 */
class OrderUpgrade {
    private static string $serviceName = "Order";

    private static string $className = "OrderUpgrade";

    /**
     * 获取订单中的拍摄主产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderSales (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSales(["id" => $id]);
    }

    /**
     * 完成订单之后添加升级服务产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function createUpgradeSku (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUpgradeSku($_params);
    }

    /**
     * 服务完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function serviceComplete (int $id = null, array $ids = null, bool $isUserComplete = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete(["id" => $id, "ids" => $ids, "isUserComplete" => $isUserComplete]);
    }

    /**
     * 设置看片完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setLookPhotoComplete (int $id = null, array $ids = null, string $type = 'user') {
        return RpcClass::getClass(self::$serviceName, self::$className)->setLookPhotoComplete(["id" => $id, "ids" => $ids, "type" => $type]);
    }

    /**
     * 看片完成标记清除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function clearLookPhotoCompletedAt (int $id = null, array $ids = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearLookPhotoCompletedAt(["id" => $id, "ids" => $ids]);
    }

    /**
     * 获取订单升级服务的产品列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUpgradeSkuList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpgradeSkuList($_params);
    }

    /**
     * 设置照片交付时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setPhotoFinishedAt (array $skuIds, string $photoFinishedAt = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoFinishedAt(["skuIds" => $skuIds, "photoFinishedAt" => $photoFinishedAt]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}