<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-13 10:08:23
 */
namespace Mainto\Bridge\Invokes\Order\OrderSaleCounter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderSaleCounter
 * @method getStoreOrderSalesByParams(array $params) 门店销售数据计数器
 * @method getProductOrderSalesByParams(array $params) 产品销售数据计数器
 * @method getReserveTimeOrderSalesByParams(array $params) 销售时间数据计数器
 * @method getAllOrderSalesByParams(array $params) 获取销售数据
 * @method getAllOrderSalesSnapByParams(array $params) 获取销售数据接口
 * @method initOrderSalesByParams(array $params) 初始化订单销售信息
 * @method removeOrderSalesByParams(array $params) 删除订单销售信息
 */
class OrderSaleCounter {
    private static string $serviceName = "Order";

    private static string $className = "OrderSaleCounter\\OrderSaleCounter";

    /**
     * 门店销售数据计数器
     * @return  mixed
    */
    public static function getStoreOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOrderSales($orderSaleSearchCommand);
    }

    /**
     * 产品销售数据计数器
     * @return  mixed
    */
    public static function getProductOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrderSales($orderSaleSearchCommand);
    }

    /**
     * 销售时间数据计数器
     * @return  mixed
    */
    public static function getReserveTimeOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReserveTimeOrderSales($orderSaleSearchCommand);
    }

    /**
     * 获取销售数据
     * @return  mixed
    */
    public static function getAllOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOrderSales($orderSaleSearchCommand);
    }

    /**
     * 获取销售数据接口
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllOrderSalesSnap (string $startReserveTime, string $endReserveTime, array $storeIds, array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOrderSalesSnap(["startReserveTime" => $startReserveTime, "endReserveTime" => $endReserveTime, "storeIds" => $storeIds, "productIds" => $productIds]);
    }

    /**
     * 初始化订单销售信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function initOrderSales (string $startReserveTime = null, string $endReserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->initOrderSales(["startReserveTime" => $startReserveTime, "endReserveTime" => $endReserveTime]);
    }

    /**
     * 删除订单销售信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function removeOrderSales (string $startReserveTime = null, string $endReserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeOrderSales(["startReserveTime" => $startReserveTime, "endReserveTime" => $endReserveTime]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}