<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-13 09:54:57
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Nps
 * @method listByParams(array $params) NPS列表
 * @method getStaffNpsListByParams(array $params) 查询伙伴的NPS列表
 * @method createByParams(array $params) 创建NPS
 * @method createV2ByParams(array $params) 创建NPS(V2)
 * @method updateByParams(array $params) 更新NPS
 * @method getByOrderIdByParams(array $params) 更加订单ID获取NPS信息
 * @method getNoneNpsOrdersByParams(array $params) 获取未评价NPS的订单
 * @method batchCheckOrderHasNpsByParams(array $params) 批量检测订单是否有nps
 */
class Nps {
    private static string $serviceName = "Order";

    private static string $className = "Nps";

    /**
     * NPS列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 查询伙伴的NPS列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffNpsList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffNpsList($_params);
    }

    /**
     * 创建NPS
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 创建NPS(V2)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createV2 (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createV2($_params);
    }

    /**
     * 更新NPS
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function update (int $id, int $all = 0, int $receptionist = 0, int $cameraman = 0, int $dresser = 0, int $retoucher = 0, int $isStat = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "all" => $all, "receptionist" => $receptionist, "cameraman" => $cameraman, "dresser" => $dresser, "retoucher" => $retoucher, "isStat" => $isStat]);
    }

    /**
     * 更加订单ID获取NPS信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByOrderId(["orderId" => $orderId]);
    }

    /**
     * 获取未评价NPS的订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getNoneNpsOrders (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoneNpsOrders($_params);
    }

    /**
     * 批量检测订单是否有nps
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchCheckOrderHasNps (array $order_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCheckOrderHasNps(["order_ids" => $order_ids]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}