<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-24 09:47:08
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createByParams(array $params) 创建订单
 * @method createIgnoreOccupyNumByParams(array $params) 创建订单——忽略占点信息
 * @method detailByParams(array $params) 订单详情
 * @method detailV2ByParams(array $params) 订单详情V2
 * @method cancelByParams(array $params) 取消订单——主订单
 * @method searchUseDbByParams(array $params) 使用数据库查询订单
 * @method searchUseEsByParams(array $params) 使用ES查询订单
 * @method getStoreWaitSignNumByParams(array $params) 获取门店等待签到的数据
 * @method removeByParams(array $params) 删除订单
 * @method deleteByUserByParams(array $params) 用户删除订单
 * @method closeByParams(array $params) 关闭订单
 * @method closeMeiTuanOrderByParams(array $params) 关闭美团订单
 * @method closeMantuOrderByParams(array $params) 关闭缦图订单
 * @method useGiftCardMoneyByParams(array $params) 修改使用礼品卡金额
 * @method giftCardPrePayByParams(array $params) 给已提交的订单使用礼品卡支付
 * @method useMarketCardMoneyByParams(array $params) 商场卡支付改价格
 * @method setPaidByParams(array $params) 设置订单完成支付——新建订单
 * @method setZeroMoneyPaidByParams(array $params) 设置零元支付订单完成支付——新建订单
 * @method startByParams(array $params) 开始订单
 * @method finishPaperlessByParams(array $params) 门店完成无纸化操作（化妆师和摄影师）
 * @method finishByParams(array $params) 门店完成订单
 * @method setOrderWorkloadsByParams(array $params) 门店录入工作量
 * @method getPaperlessWorkloadsByParams(array $params) 获取工作量
 * @method getPaperlessWorkloadsListByParams(array $params) 批量获取工作量
 * @method completeLookPhotoByParams(array $params) 完成看片
 * @method serviceCompleteByParams(array $params) 服务整体完成（用户确认服务完成）
 * @method changeReserveTimeByParams(array $params) 修改预约时间
 * @method clearConfirmationByParams(array $params) 看片自动确认标记清除
 * @method getConfirmationByIdsByParams(array $params) 根据订单id查询自动看片完成信息
 * @method changeLookPhotoReserveTimeByParams(array $params) 改变订单的看片预约时间
 * @method recoverWaitShootingByParams(array $params) 恢复到等待拍摄状态
 * @method recoverFinishedToWaitShootingByParams(array $params) 把完成的订单恢复到等待拍摄
 * @method getOrderStatusByParams(array $params) 获取门店下订单不同状态数量【专供缦图订单接口】
 * @method getIdByNoByParams(array $params) 根据订单号获取订单ID
 * @method getIdByNosByParams(array $params) 根据订单号批量获取订单ID
 * @method getNoByIdByParams(array $params) 根据订单ID获取订单号
 * @method bindUserByParams(array $params) 绑定用户
 * @method unbindUserByParams(array $params) 解绑用户
 * @method batchUpdateInvoiceIdByParams(array $params) 批量更新订单的发票ID
 * @method getOrderConsumeMoneyByParams(array $params) 计算订单消费金额
 * @method getOrderOperateLogByParams(array $params) 查看订单操作日志
 * @method batchGetOrdersOperateLogByParams(array $params) 批量查看订单操作日志
 * @method getOrderOperateLogCountByParams(array $params) 获取订单某操作记录次数
 * @method changeUserDataByParams(array $params) 修改用户数据
 * @method changeStoreByParams(array $params) 转换门店
 * @method queryDsListWithStoreByParams(array $params) 根据门店查询二销
 * @method getProductsInOrderByParams(array $params) 根据订单号获取订单下面买的产品
 * @method getProductsInOrdersByParams(array $params) 根据订单号批量获取订单下面买的产品
 * @method changeExtendByParams(array $params) 修改订单extend数据
 * @method userReachedByParams(array $params) 设置拍摄订单签到
 * @method getUserReachedDetailByParams(array $params) 拍摄签到详情
 * @method modifyUserReachedByParams(array $params) 修改拍摄订单签到
 * @method cancelUserReachedByParams(array $params) 取消拍摄签到
 * @method setUserReachedPaidByParams(array $params) 设置签到完成支付
 * @method getStoreFinishOrderCountByParams(array $params) 获取门店订单完成数量
 * @method setOrderPaperlessFinishByParams(array $params) 设置订单的无纸化完成
 * @method getInvoiceListByParams(array $params) 获取订单可开发票信息接口
 * @method getInvoiceAllByParams(array $params) 获取订单可开发票信息接口
 * @method getStoreOrderCountByParams(array $params) 获取上个月门店订单完成数量
 * @method getOrderUnSetServiceCompleteByParams(array $params) 根据看片时间获取未设置完成服务的拍摄产品
 * @method searchOrderNoByParams(array $params) 查询订单编号
 * @method getOrderLookPhotoReserveLitByParams(array $params) 获取预约看片信息
 * @method getOrderNosByIdsByParams(array $params) 根据订单Ids批量获取订单号
 * @method getOrderSaleSkuAndUpgradeSkuByParams(array $params) 获取订单的拍摄产品和升级服务产品
 * @method isBindUserByParams(array $params) 获取订单是否绑定用户
 * @method getProductOrdersByParams(array $params) 获取拍摄产品的订单
 * @method getProductOrderListByParams(array $params) 获取拍摄产品的订单——分页
 * @method searchOrdersWithAllSkusByParams(array $params) 查询订单及其所有的拍摄产品信息
 * @method searchOrdersWithAllSkusUseDbByParams(array $params) 查询订单及其所有的拍摄产品信息——使用db
 * @method retailOrderHookChangeStoreByParams(array $params) 转门店带零售订单
 * @method searchOrderWithSkuByParams(array $params) 查询订单以及拍摄产品信息
 * @method getUserInvoiceStoreListByParams(array $params) 获取用户可开发票的门店列表
 * @method getOrderStoreIdsByUserIdByParams(array $params) 获取用户订单所在门店
 * @method getAlreadyInvoiceOrderByUserIdByParams(array $params) 获取用户已开票订单
 * @method searchOrderBasicByParams(array $params) 批量查询订单基础信息
 * @method setStudentMembershipByParams(array $params) 设置学生会员信息
 * @method cleanStudentMembershipByParams(array $params) 清除学生会员信息
 * @method orderBasicDetailByParams(array $params) 订单基础详情
 * @method createOrderBalancePaymentByParams(array $params) 创建尾款支付
 * @method groupOrderPaidByParams(array $params) 团购订单支付
 * @method orderPeoplesByParams(array $params) 获取订单的拍摄人数信息
 * @method setPhotoFinishedAtByParams(array $params) 设置照片交付时间
 * @method addOrderOperateSkipMakeupByParams(array $params) 增加跳过化妆操作记录
 * @method addOperateLogByParams(array $params) 订单操作记录
 * @method getUserMemberOrderListByParams(array $params) 会员服务分页获取获取服务完成的订单
 * @method searchOrderBaseInfoUseEsByParams(array $params) 查询订单主表和extend表信息
 * @method calcOrderDiscountMoneyByDiscountTypeByParams(array $params) 查询支付但未完成的订单指定的优惠类型后的订单金额
 * @method searchOrderOnlyEsInfoByParams(array $params) 只查询es中存在的参数返回结果-不回查数据库
 */
class Order {
    private static string $serviceName = "Order";

    private static string $className = "Order";

    /**
     * 创建订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 创建订单——忽略占点信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function createIgnoreOccupyNum (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createIgnoreOccupyNum($_params);
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false, bool $withTagInfo = false, bool $withStandbyTime = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withRefund" => $withRefund, "withModifyRefund" => $withModifyRefund, "withTagInfo" => $withTagInfo, "withStandbyTime" => $withStandbyTime]);
    }

    /**
     * 订单详情V2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailV2 (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false, bool $withTurnover = false, bool $withTagInfo = false, bool $withStandbyTime = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailV2(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withRefund" => $withRefund, "withModifyRefund" => $withModifyRefund, "withTurnover" => $withTurnover, "withTagInfo" => $withTagInfo, "withStandbyTime" => $withStandbyTime]);
    }

    /**
     * 取消订单——主订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function cancel (int $id, string $reason, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 使用数据库查询订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchUseDb (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUseDb($_params);
    }

    /**
     * 使用ES查询订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchUseEs (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUseEs($_params);
    }

    /**
     * 获取门店等待签到的数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreWaitSignNum (int $storeId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreWaitSignNum(["storeId" => $storeId, "reserveTime" => $reserveTime]);
    }

    /**
     * 删除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function remove (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, "operateId" => $operateId]);
    }

    /**
     * 用户删除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteByUser (int $id, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteByUser(["id" => $id, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function close (int $id, string $reason, int $operateId, string $note = '', int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "reason" => $reason, "operateId" => $operateId, "note" => $note, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 关闭美团订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeMeiTuanOrder (int $id, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMeiTuanOrder(["id" => $id, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 关闭缦图订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeMantuOrder (int $id, string $reason = '', int $operateId = 0, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMantuOrder(["id" => $id, "reason" => $reason, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 修改使用礼品卡金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney, array $attachInfo = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useGiftCardMoney(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney, "attachInfo" => $attachInfo]);
    }

    /**
     * 给已提交的订单使用礼品卡支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function giftCardPrePay (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPrePay(["id" => $id]);
    }

    /**
     * 商场卡支付改价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useMarketCardMoney(["id" => $id, "marketCardMoney" => $marketCardMoney]);
    }

    /**
     * 设置订单完成支付——新建订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false, float $paymentMoney = null, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway, "paymentMoney" => $paymentMoney, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 设置零元支付订单完成支付——新建订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setZeroMoneyPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setZeroMoneyPaid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 开始订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function start (int $id, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->start(["id" => $id, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 门店完成无纸化操作（化妆师和摄影师）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function finishPaperless (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPaperless(["id" => $id]);
    }

    /**
     * 门店完成订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function finish (int $id, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["id" => $id, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 门店录入工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setOrderWorkloads (int $id, array $workloads, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderWorkloads(["id" => $id, "workloads" => $workloads, "operateId" => $operateId]);
    }

    /**
     * 获取工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPaperlessWorkloads (int $id, array $staffTypes = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessWorkloads(["id" => $id, "staffTypes" => $staffTypes]);
    }

    /**
     * 批量获取工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPaperlessWorkloadsList (array $ids, array $staffTypes = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessWorkloadsList(["ids" => $ids, "staffTypes" => $staffTypes]);
    }

    /**
     * 完成看片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function completeLookPhoto (int $id, int $staffId = 0, int $workPer = 0, string $type = 'user', int $storeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->completeLookPhoto(["id" => $id, "staffId" => $staffId, "workPer" => $workPer, "type" => $type, "storeId" => $storeId]);
    }

    /**
     * 服务整体完成（用户确认服务完成）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function serviceComplete (int $id, string $type, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete(["id" => $id, "type" => $type, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 修改预约时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId, string $note = '', int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = [], int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserveTime" => $reserveTime, "operateId" => $operateId, "note" => $note, "occupyNum" => $occupyNum, "from" => $from, "occupyIndexs" => $occupyIndexs, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 看片自动确认标记清除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function clearConfirmation (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearConfirmation(["id" => $id]);
    }

    /**
     * 根据订单id查询自动看片完成信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getConfirmationByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getConfirmationByIds(["ids" => $ids]);
    }

    /**
     * 改变订单的看片预约时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function changeLookPhotoReserveTime (int $id, int $operateId, string $lookPhotoReserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeLookPhotoReserveTime(["id" => $id, "operateId" => $operateId, "lookPhotoReserveTime" => $lookPhotoReserveTime]);
    }

    /**
     * 恢复到等待拍摄状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function recoverWaitShooting (int $id, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverWaitShooting(["id" => $id, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 把完成的订单恢复到等待拍摄
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function recoverFinishedToWaitShooting (int $id, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverFinishedToWaitShooting(["id" => $id, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 获取门店下订单不同状态数量【专供缦图订单接口】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStatus(["storeId" => $storeId, "module" => $module, "needToday" => $needToday]);
    }

    /**
     * 根据订单号获取订单ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getIdByNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["orderNo" => $orderNo]);
    }

    /**
     * 根据订单号批量获取订单ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getIdByNos (array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNos(["orderNos" => $orderNos]);
    }

    /**
     * 根据订单ID获取订单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getNoById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoById(["id" => $id]);
    }

    /**
     * 绑定用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bindUser (int $id, int $userId, string $userPhone, bool $force = false, int $operateId = 0, string $bindReason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUser(["id" => $id, "userId" => $userId, "userPhone" => $userPhone, "force" => $force, "operateId" => $operateId, "bindReason" => $bindReason]);
    }

    /**
     * 解绑用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function unbindUser (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindUser(["id" => $id, "operateId" => $operateId]);
    }

    /**
     * 批量更新订单的发票ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateInvoiceId(["invoiceId" => $invoiceId, "orderNos" => $orderNos]);
    }

    /**
     * 计算订单消费金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderConsumeMoney (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderConsumeMoney(["id" => $id]);
    }

    /**
     * 查看订单操作日志
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderOperateLog (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOperateLog(["orderId" => $orderId]);
    }

    /**
     * 批量查看订单操作日志
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchGetOrdersOperateLog (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetOrdersOperateLog(["orderIds" => $orderIds]);
    }

    /**
     * 获取订单某操作记录次数
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderOperateLogCount (int $orderId, array $actions, bool $includeTransfer = false, string $from = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOperateLogCount(["orderId" => $orderId, "actions" => $actions, "includeTransfer" => $includeTransfer, "from" => $from]);
    }

    /**
     * 修改用户数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changeUserData (int $id, string $userName = null, string $userSex = null, string $userEmail = null, string $userBirthday = null, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "userName" => $userName, "userSex" => $userSex, "userEmail" => $userEmail, "userBirthday" => $userBirthday, "operateId" => $operateId]);
    }

    /**
     * 转换门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changeStore (int $id, int $storeId, string $reserveTime, int $operateId, int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = [], bool $setReservation = true, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime, "operateId" => $operateId, "occupyNum" => $occupyNum, "from" => $from, "occupyIndexs" => $occupyIndexs, "setReservation" => $setReservation, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 根据门店查询二销
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function queryDsListWithStore (int $staffId, string $startTime, string $endTime, int $dsModel = 2, int $storeId = 0, bool $withUpgrade = true, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryDsListWithStore(["staffId" => $staffId, "startTime" => $startTime, "endTime" => $endTime, "dsModel" => $dsModel, "storeId" => $storeId, "withUpgrade" => $withUpgrade, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsInOrder (string $orderNo = '', int $orderId = 0, int $orderSaleId = null, bool $withDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrder(["orderNo" => $orderNo, "orderId" => $orderId, "orderSaleId" => $orderSaleId, "withDeleted" => $withDeleted]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsInOrders (array $orderNos = [], array $orderIds = [], bool $withDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrders(["orderNos" => $orderNos, "orderIds" => $orderIds, "withDeleted" => $withDeleted]);
    }

    /**
     * 修改订单extend数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function changeExtend (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeExtend($_params);
    }

    /**
     * 设置拍摄订单签到
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function userReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "inputStaffId" => $inputStaffId, "needMoney" => $needMoney, "money" => $money]);
    }

    /**
     * 拍摄签到详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getUserReachedDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserReachedDetail(["orderId" => $orderId]);
    }

    /**
     * 修改拍摄订单签到
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function modifyUserReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyUserReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "inputStaffId" => $inputStaffId, "needMoney" => $needMoney, "money" => $money]);
    }

    /**
     * 取消拍摄签到
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelUserReached (int $orderId, int $orderDiffId, int $inputStaffId, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelUserReached(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "inputStaffId" => $inputStaffId, "reason" => $reason]);
    }

    /**
     * 设置签到完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserReachedPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway]);
    }

    /**
     * 获取门店订单完成数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreFinishOrderCount (string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreFinishOrderCount(["startDate" => $startDate, "endDate" => $endDate]);
    }

    /**
     * 设置订单的无纸化完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setOrderPaperlessFinish (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderPaperlessFinish(["id" => $id]);
    }

    /**
     * 获取订单可开发票信息接口
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getInvoiceList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvoiceList($_params);
    }

    /**
     * 获取订单可开发票信息接口
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getInvoiceAll (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvoiceAll($_params);
    }

    /**
     * 获取上个月门店订单完成数量
     * @return  mixed
    */
    public static function getStoreOrderCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOrderCount();
    }

    /**
     * 根据看片时间获取未设置完成服务的拍摄产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getOrderUnSetServiceComplete (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderUnSetServiceComplete($_params);
    }

    /**
     * 查询订单编号
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchOrderNo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderNo($_params);
    }

    /**
     * 获取预约看片信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getOrderLookPhotoReserveLit (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderLookPhotoReserveLit($_params);
    }

    /**
     * 根据订单Ids批量获取订单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderNosByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderNosByIds(["ids" => $ids]);
    }

    /**
     * 获取订单的拍摄产品和升级服务产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getOrderSaleSkuAndUpgradeSku (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSaleSkuAndUpgradeSku($_params);
    }

    /**
     * 获取订单是否绑定用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function isBindUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isBindUser(["id" => $id]);
    }

    /**
     * 获取拍摄产品的订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getProductOrders (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrders($_params);
    }

    /**
     * 获取拍摄产品的订单——分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getProductOrderList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrderList($_params);
    }

    /**
     * 查询订单及其所有的拍摄产品信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchOrdersWithAllSkus (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrdersWithAllSkus($_params);
    }

    /**
     * 查询订单及其所有的拍摄产品信息——使用db
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchOrdersWithAllSkusUseDb (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrdersWithAllSkusUseDb($_params);
    }

    /**
     * 转门店带零售订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function retailOrderHookChangeStore (int $orderId, int $newStoreId, int $newOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOrderHookChangeStore(["orderId" => $orderId, "newStoreId" => $newStoreId, "newOrderId" => $newOrderId]);
    }

    /**
     * 查询订单以及拍摄产品信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchOrderWithSku (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderWithSku($_params);
    }

    /**
     * 获取用户可开发票的门店列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUserInvoiceStoreList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInvoiceStoreList($_params);
    }

    /**
     * 获取用户订单所在门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderStoreIdsByUserId (int $userId, array $statusList = [], bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStoreIdsByUserId(["userId" => $userId, "statusList" => $statusList, "withDel" => $withDel]);
    }

    /**
     * 获取用户已开票订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAlreadyInvoiceOrderByUserId (int $userId, array $statusList = [], string $module = 'himo', bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAlreadyInvoiceOrderByUserId(["userId" => $userId, "statusList" => $statusList, "module" => $module, "withDel" => $withDel]);
    }

    /**
     * 批量查询订单基础信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchOrderBasic (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderBasic($_params);
    }

    /**
     * 设置学生会员信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setStudentMembership (int $orderId, string $studentMembership, bool $forcedRefresh = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStudentMembership(["orderId" => $orderId, "studentMembership" => $studentMembership, "forcedRefresh" => $forcedRefresh]);
    }

    /**
     * 清除学生会员信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function cleanStudentMembership (int $orderId, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanStudentMembership(["orderId" => $orderId, "operateId" => $operateId]);
    }

    /**
     * 订单基础详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function orderBasicDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderBasicDetail($_params);
    }

    /**
     * 创建尾款支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createOrderBalancePayment (int $id, float $paidMoney, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrderBalancePayment(["id" => $id, "paidMoney" => $paidMoney, "operateId" => $operateId]);
    }

    /**
     * 团购订单支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function groupOrderPaid (int $orderId, int $orderDiffId, array $groupOrderItemIds, int $inputStaffId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupOrderPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "groupOrderItemIds" => $groupOrderItemIds, "inputStaffId" => $inputStaffId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 获取订单的拍摄人数信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function orderPeoples (array $orderIds, array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderPeoples(["orderIds" => $orderIds, "orderNos" => $orderNos]);
    }

    /**
     * 设置照片交付时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setPhotoFinishedAt (int $orderId, string $photoFinishedAt = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoFinishedAt(["orderId" => $orderId, "photoFinishedAt" => $photoFinishedAt]);
    }

    /**
     * 增加跳过化妆操作记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addOrderOperateSkipMakeup (int $orderId, string $time, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderOperateSkipMakeup(["orderId" => $orderId, "time" => $time, "operateId" => $operateId]);
    }

    /**
     * 订单操作记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addOperateLog (int $orderId, string $time, string $operate, int $operateId, string $remark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOperateLog(["orderId" => $orderId, "time" => $time, "operate" => $operate, "operateId" => $operateId, "remark" => $remark]);
    }

    /**
     * 会员服务分页获取获取服务完成的订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUserMemberOrderList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserMemberOrderList($_params);
    }

    /**
     * 查询订单主表和extend表信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchOrderBaseInfoUseEs (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderBaseInfoUseEs($_params);
    }

    /**
     * 查询支付但未完成的订单指定的优惠类型后的订单金额
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function calcOrderDiscountMoneyByDiscountType (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calcOrderDiscountMoneyByDiscountType($_params);
    }

    /**
     * 只查询es中存在的参数返回结果-不回查数据库
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchOrderOnlyEsInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderOnlyEsInfo($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}