<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-21 11:29:04
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Workload
 * @method listByParams(array $params) 工作量列表
 * @method getListByOrderIdByParams(array $params) 根据订单ID查询该订单的工作量列表
 * @method inputByStoreByParams(array $params) 门店录入工作量
 * @method resetByParams(array $params) 重置工作量
 * @method inputKpsWorkloadByParams(array $params) 云端录入工作量
 */
class Workload {
    private static string $serviceName = "Order";

    private static string $className = "Workload";

    /**
     * 工作量列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 根据订单ID查询该订单的工作量列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getListByOrderId (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByOrderId(["order_id" => $order_id]);
    }

    /**
     * 门店录入工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function inputByStore (int $orderId, array $workloads, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inputByStore(["orderId" => $orderId, "workloads" => $workloads, "operateId" => $operateId]);
    }

    /**
     * 重置工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function reset (int $orderId, array $workloads) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reset(["orderId" => $orderId, "workloads" => $workloads]);
    }

    /**
     * 云端录入工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function inputKpsWorkload (int $orderId, int $staffId, int $workPer, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inputKpsWorkload(["orderId" => $orderId, "staffId" => $staffId, "workPer" => $workPer, "storeId" => $storeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}