<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-19 15:26:12
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OfflineOrder
 * @method listByParams(array $params) 订单列表
 * @method detailByParams(array $params) 订单详情
 * @method detailByNoByParams(array $params) 订单详情【根据订单号获取】
 * @method createByParams(array $params) 创建订单
 * @method getIdByNoByParams(array $params) 根据订单号获取订单ID
 * @method getNosByIdsByParams(array $params) 根据ids获取订单order_no列表
 * @method removeByParams(array $params) 移除订单
 * @method setPaidByParams(array $params) 设置订单完成支付
 * @method allIncomeItemsByParams(array $params) 全部收入项目
 * @method batchUpdateInvoiceIdByParams(array $params) 批量更新订单的发票ID
 * @method changePayTypeByParams(array $params) 修改支付方式
 * @method changeReserveTimeByParams(array $params) 修改预约时间
 * @method setOrderFinishedByParams(array $params) 设置订单完成并录入工作量
 */
class OfflineOrder {
    private static string $serviceName = "Order";

    private static string $className = "OfflineOrder";

    /**
     * 订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 订单详情【根据订单号获取】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detailByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNo(["order_no" => $order_no]);
    }

    /**
     * 创建订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 根据订单号获取订单ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getIdByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["order_no" => $order_no]);
    }

    /**
     * 根据ids获取订单order_no列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getNosByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNosByIds(["ids" => $ids]);
    }

    /**
     * 移除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }

    /**
     * 设置订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setPaid (int $id, string $payType, string $paymentNo = '', float $payMoney = null, string $dianpingCouponCode = '', int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo, "payMoney" => $payMoney, "dianpingCouponCode" => $dianpingCouponCode, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 全部收入项目
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function allIncomeItems (bool $withHidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allIncomeItems(["withHidden" => $withHidden]);
    }

    /**
     * 批量更新订单的发票ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateInvoiceId(["invoice_id" => $invoice_id, "order_nos" => $order_nos]);
    }

    /**
     * 修改支付方式
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function changePayType (int $id, string $pay_type, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(array_merge($_params, ["id" => $id, "pay_type" => $pay_type]));
    }

    /**
     * 修改预约时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserveTime" => $reserveTime, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 设置订单完成并录入工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setOrderFinished (int $id, array $workloads, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderFinished(["id" => $id, "workloads" => $workloads, "operateId" => $operateId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}