<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-19 15:26:12
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class HotfixOrderV4
 * @method hotfixJxjyByParams(array $params) 修复加修加印的接口
 * @method hotfixOrderServiceCompleteByParams(array $params) 修复订单完成服务
 * @method hotfixUserOrderServiceCompleteByParams(array $params) 修复用户订单完成服务
 * @method hotfixSetOrderPaidByParams(array $params) 设置未支付的订单完成支付
 * @method batchLookPhotoByParams(array $params) 批量修复完成看片信息
 * @method batchOrderServiceCompleteByParams(array $params) 批量修复完成看片信息
 * @method repairCancelReserveByParams(array $params) 修复取消排单表
 * @method syncToOrderOperateByParams(array $params) 通知到DEV环境记录操作日志
 * @method refundCouponByParams(array $params) 修复退款的优惠券信息
 * @method closeSubmittedOrderByParams(array $params) 关闭已提交订单
 * @method closeOrderReserveAndPaperlessCloseByParams(array $params) 关闭订单拍单表以及无纸化
 * @method monitorOrderEsByParams(array $params) 每1分钟检查一次es同步是否正常
 * @method pictureOrderSnapshotByParams(array $params) 特殊数据人工修复快照---拍摄订单
 * @method groupOrderSnapshotByParams(array $params) 特殊数据人工修复快照---团购订单
 * @method offlineOrderSnapshotByParams(array $params) 特殊数据人工修复快照---线下订单
 * @method closeMeiTuanAbnormalOrderByParams(array $params) 每天7点，从大数据获取需要关闭的订单列表进行关闭
 * @method deleteRetakeOrderByParams(array $params) 删除订单
 * @method deleteOrderInvoiceByParams(array $params) 删除订单发票信息
 * @method closeAllOrderByParams(array $params) 关闭所有类型订单
 * @method setManTuOrderPhotoFinishedTimeByParams(array $params) 设置缦图订单
 * @method fixSkuExtendGonggeConfigByParams(array $params) 修复订单gongge_config
 * @method fixCloseMeiTuanOrderByParams(array $params) 恢复美团订单
 * @method fixOldOrderDataByParams(array $params) 修复老订单数据
 */
class HotfixOrderV4 {
    private static string $serviceName = "Order";

    private static string $className = "HotfixOrderV4";

    /**
     * 修复加修加印的接口
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function hotfixJxjy (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hotfixJxjy($_params);
    }

    /**
     * 修复订单完成服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hotfixOrderServiceComplete (int $orderId, string $serviceCompletedAt = null, string $serviceCompletedType = null, bool $sendServiceCompleteMessage = false, bool $useNpsAt = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hotfixOrderServiceComplete(["orderId" => $orderId, "serviceCompletedAt" => $serviceCompletedAt, "serviceCompletedType" => $serviceCompletedType, "sendServiceCompleteMessage" => $sendServiceCompleteMessage, "useNpsAt" => $useNpsAt]);
    }

    /**
     * 修复用户订单完成服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hotfixUserOrderServiceComplete (int $userId, bool $sendServiceCompleteMessage = false, bool $useNpsAt = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hotfixUserOrderServiceComplete(["userId" => $userId, "sendServiceCompleteMessage" => $sendServiceCompleteMessage, "useNpsAt" => $useNpsAt]);
    }

    /**
     * 设置未支付的订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hotfixSetOrderPaid (int $orderId, int $orderDiffId, string $payType, string $paymentNo, bool $isFirstPaid = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hotfixSetOrderPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType, "paymentNo" => $paymentNo, "isFirstPaid" => $isFirstPaid]);
    }

    /**
     * 批量修复完成看片信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchLookPhoto (array $lookPhotoData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchLookPhoto(["lookPhotoData" => $lookPhotoData]);
    }

    /**
     * 批量修复完成看片信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchOrderServiceComplete (array $orderInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchOrderServiceComplete(["orderInfo" => $orderInfo]);
    }

    /**
     * 修复取消排单表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function repairCancelReserve (int $orderId, string $type = 'shoot_picture', bool $forcedRefresh = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->repairCancelReserve(["orderId" => $orderId, "type" => $type, "forcedRefresh" => $forcedRefresh]);
    }

    /**
     * 通知到DEV环境记录操作日志
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function syncToOrderOperate (int $orderId, int $staffId, string $action, array $extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncToOrderOperate(["orderId" => $orderId, "staffId" => $staffId, "action" => $action, "extend" => $extend]);
    }

    /**
     * 修复退款的优惠券信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refundCoupon (int $orderId, int $couponId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundCoupon(["orderId" => $orderId, "couponId" => $couponId]);
    }

    /**
     * 关闭已提交订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeSubmittedOrder (string $startAt, string $endAt, string $module = 'himo') {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeSubmittedOrder(["startAt" => $startAt, "endAt" => $endAt, "module" => $module]);
    }

    /**
     * 关闭订单拍单表以及无纸化
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeOrderReserveAndPaperlessClose (string $orderNo, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrderReserveAndPaperlessClose(["orderNo" => $orderNo, "reason" => $reason]);
    }

    /**
     * 每1分钟检查一次es同步是否正常
     * @return  mixed
    */
    public static function monitorOrderEs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->monitorOrderEs();
    }

    /**
     * 特殊数据人工修复快照---拍摄订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function pictureOrderSnapshot (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pictureOrderSnapshot(["orderId" => $orderId]);
    }

    /**
     * 特殊数据人工修复快照---团购订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function groupOrderSnapshot (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupOrderSnapshot(["orderId" => $orderId]);
    }

    /**
     * 特殊数据人工修复快照---线下订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function offlineOrderSnapshot (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offlineOrderSnapshot(["orderId" => $orderId]);
    }

    /**
     * 每天7点，从大数据获取需要关闭的订单列表进行关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeMeiTuanAbnormalOrder (int $pageNum = 1, int $pageSize = 2000) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMeiTuanAbnormalOrder(["pageNum" => $pageNum, "pageSize" => $pageSize]);
    }

    /**
     * 删除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteRetakeOrder (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteRetakeOrder(["orderNo" => $orderNo]);
    }

    /**
     * 删除订单发票信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteOrderInvoice (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrderInvoice(["orderNo" => $orderNo]);
    }

    /**
     * 关闭所有类型订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeAllOrder (string $orderNo, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeAllOrder(["orderNo" => $orderNo, "reason" => $reason]);
    }

    /**
     * 设置缦图订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setManTuOrderPhotoFinishedTime (string $orderNo, string $lookPhotoCompletedAt, string $photoFinishedAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setManTuOrderPhotoFinishedTime(["orderNo" => $orderNo, "lookPhotoCompletedAt" => $lookPhotoCompletedAt, "photoFinishedAt" => $photoFinishedAt]);
    }

    /**
     * 修复订单gongge_config
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function fixSkuExtendGonggeConfig (int $skuExtendId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixSkuExtendGonggeConfig(["skuExtendId" => $skuExtendId]);
    }

    /**
     * 恢复美团订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function fixCloseMeiTuanOrder (string $orderNo, string $oldStatus, string $nowStatus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCloseMeiTuanOrder(["orderNo" => $orderNo, "oldStatus" => $oldStatus, "nowStatus" => $nowStatus]);
    }

    /**
     * 修复老订单数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function fixOldOrderData (string $orderNo, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixOldOrderData(["orderNo" => $orderNo, "type" => $type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}