<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-05-14 09:52:56
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OtherOrderRefund
 * @method listByParams(array $params) 退款列表
 * @method detailByParams(array $params) 退款详情
 * @method createByParams(array $params) 创建退款
 * @method removeByParams(array $params) 删除退款
 * @method passByParams(array $params) 通过退款
 * @method rejectByParams(array $params) 拒绝退款
 * @method getStaffRetailOtherOrderRefundByParams(array $params) 获取伙伴时间范围内累积的退款数据
 * @method detailWithOrderByParams(array $params) 退款详情
 */
class OtherOrderRefund {
    private static string $serviceName = "Order";

    private static string $className = "OtherOrderRefund";

    /**
     * 退款列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 退款详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 创建退款
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 删除退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }

    /**
     * 通过退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function pass (int $id, string $paymentNo, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, "paymentNo" => $paymentNo, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 拒绝退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function reject (int $id, string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "reason" => $reason]);
    }

    /**
     * 获取伙伴时间范围内累积的退款数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffRetailOtherOrderRefund (int $staffId, string $startTime = '', string $endTime = '', array $orderNos = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRetailOtherOrderRefund(["staffId" => $staffId, "startTime" => $startTime, "endTime" => $endTime, "orderNos" => $orderNos]);
    }

    /**
     * 退款详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detailWithOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithOrder(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}