<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-21 14:58:43
 */
namespace Mainto\Bridge\Structs\Order\OfflineOrder\Command;

class OfflineOrderItem {
    /**
     * @var  null|int
     * 购买项ID，编辑时需要
     * validation: 
     */
    public ?int $id = null;
    /**
     * @var  string
     * 产品类型
     * validation: type:offlineIncomeItemType
     */
    public string $type;
    /**
     * @var  string
     * 产品名称
     * validation: 
     */
    public string $name;
    /**
     * @var  string
     * 产品状态
     * validation: type:offlineIncomeItemStatus
     */
    public string $status;
    /**
     * @var  null|int
     * 上级id
     * validation: 
     */
    public ?int $parentId = null;
    /**
     * @var  null|float
     * 售卖价格
     * validation: 
     */
    public ?float $price = null;
    /**
     * @var  int
     * 是否自定义输入价格
     * validation: in:0,1
     */
    public int $needCustom;
    /**
     * @var  null|int
     * 关联拍摄产品ID
     * validation: 
     */
    public ?int $photoProductId = null;

    public function __construct (string $type = '', string $name = '', string $status = '', int $needCustom = 0) {
        if (!is_null($type)) {
            $this->type = $type;
        }
        if (!is_null($name)) {
            $this->name = $name;
        }
        if (!is_null($status)) {
            $this->status = $status;
        }
        if (!is_null($needCustom)) {
            $this->needCustom = $needCustom;
        }
    }

    public static function create(string $type = '', string $name = '', string $status = '', int $needCustom = 0): self {
        return new self($type, $name, $status, $needCustom);
    }

    public function setId(?int $id): self {
        $this->id = $id;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setParentId(?int $parentId): self {
        $this->parentId = $parentId;

        return $this;
    }

    public function setPrice(?float $price): self {
        $this->price = $price;

        return $this;
    }

    public function setNeedCustom(int $needCustom): self {
        $this->needCustom = $needCustom;

        return $this;
    }

    public function setPhotoProductId(?int $photoProductId): self {
        $this->photoProductId = $photoProductId;

        return $this;
    }
}