<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-15 10:51:26
 */
namespace Mainto\Bridge\Structs\Order\Refund\Command\CreateRefund;

class CreateRefundCommand {
    /**
     * @var  int
     * 订单id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  string
     * 退款类型
     * validation: in:full_refund,part_refund,special_order_refund,special_sku_refund
     */
    public string $refundType = "part_refund";
    /**
     * @var  string
     * 退款金额类型
     * validation: in:normal,compensation
     */
    public string $refundMoneyType = "normal";
    /**
     * @var  null|float
     * 退款金额
     * validation: 
     */
    public ?float $refundMoney = null;
    /**
     * @var  bool
     * 是否包含退款区间
     * validation: 
     */
    public bool $withAmountRange = true;
    /**
     * @var  int
     * 比例
     * validation: between:0,100
     */
    public int $scale = 100;
    /**
     * @var  string
     * 退款人
     * validation: 
     */
    public string $people;
    /**
     * @var  string
     * 退款账户
     * validation: 
     */
    public string $account;
    /**
     * @var  string
     * 原因
     * validation: 
     */
    public string $reason;
    /**
     * @var  null|array
     * 原因Ids
     * validation: 
     */
    public ?array $reasonIds = [];
    /**
     * @var  null|string
     * 备注
     * validation: 
     */
    public ?string $note = null;
    /**
     * @var  int
     * 录入人伙伴ID
     * validation: 
     */
    public int $inputStaffId;
    /**
     * @var  string
     * 来源，用户预约端申请，后台申请
     * validation: 
     */
    public string $from;
    /**
     * @var  bool
     * 是否包含删除的订单
     * validation: 
     */
    public bool $withDelete = false;
    /**
     * @var  bool
     * 是否快速退款
     * validation: 
     */
    public bool $isFastRefund = false;
    /**
     * @var  \Mainto\Bridge\Structs\Order\Refund\Command\Common\RefundInfoCommand[]
     * 退款项(包含退款类型：order 订单 upgrade 升级服务)
     * validation: 
     */
    public array $refundInfo;
    /**
     * @var  null|array
     * 退款扩展参数
     * validation: 
     */
    public ?array $extend = [];

    public function __construct (int $orderId = 0, string $people = '', string $account = '', string $reason = '', int $inputStaffId = 0, string $from = '', array $refundInfo = []) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($people)) {
            $this->people = $people;
        }
        if (!is_null($account)) {
            $this->account = $account;
        }
        if (!is_null($reason)) {
            $this->reason = $reason;
        }
        if (!is_null($inputStaffId)) {
            $this->inputStaffId = $inputStaffId;
        }
        if (!is_null($from)) {
            $this->from = $from;
        }
        if (!is_null($refundInfo)) {
            $this->refundInfo = $refundInfo;
        }
    }

    public static function create(int $orderId = 0, string $people = '', string $account = '', string $reason = '', int $inputStaffId = 0, string $from = '', array $refundInfo = []): self {
        return new self($orderId, $people, $account, $reason, $inputStaffId, $from, $refundInfo);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setRefundType(string $refundType): self {
        $this->refundType = $refundType;

        return $this;
    }

    public function setRefundMoneyType(string $refundMoneyType): self {
        $this->refundMoneyType = $refundMoneyType;

        return $this;
    }

    public function setRefundMoney(?float $refundMoney): self {
        $this->refundMoney = $refundMoney;

        return $this;
    }

    public function setWithAmountRange(bool $withAmountRange): self {
        $this->withAmountRange = $withAmountRange;

        return $this;
    }

    public function setScale(int $scale): self {
        $this->scale = $scale;

        return $this;
    }

    public function setPeople(string $people): self {
        $this->people = $people;

        return $this;
    }

    public function setAccount(string $account): self {
        $this->account = $account;

        return $this;
    }

    public function setReason(string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setReasonIds(?array $reasonIds): self {
        $this->reasonIds = $reasonIds;

        return $this;
    }

    public function setNote(?string $note): self {
        $this->note = $note;

        return $this;
    }

    public function setInputStaffId(int $inputStaffId): self {
        $this->inputStaffId = $inputStaffId;

        return $this;
    }

    public function setFrom(string $from): self {
        $this->from = $from;

        return $this;
    }

    public function setWithDelete(bool $withDelete): self {
        $this->withDelete = $withDelete;

        return $this;
    }

    public function setIsFastRefund(bool $isFastRefund): self {
        $this->isFastRefund = $isFastRefund;

        return $this;
    }

    public function setRefundInfo(array $refundInfo): self {
        $this->refundInfo = $refundInfo;

        return $this;
    }

    public function setExtend(?array $extend): self {
        $this->extend = $extend;

        return $this;
    }
}