<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-08 10:39:36
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderDiff
 * @method detailByParams(array $params) 获取未支付的详情
 * @method cancelByParams(array $params) 取消未支付订单
 * @method onTimeCloseNoPaidUpdateOrderByParams(array $params) onTimeCloseNoPaidUpdateOrder
 * @method setPaidByParams(array $params) 设置未支付的订单完成支付
 * @method setZeroMoneyPaidByParams(array $params) 设置未支付的订单完成支付
 * @method getOrdersBySubOrderNosByParams(array $params) 通过子订单号批量查询diff订单-数据同步
 * @method getDiffTypeByParams(array $params) 获取未支付的详情
 * @method saveDepositOrderByParams(array $params) 保存未支付的订单
 * @method calRetailNeedPaidMoneyByParams(array $params) 计算在订单系统中下单的零售需要支付的金额
 */
class OrderDiff {
    private static string $serviceName = "Order";

    private static string $className = "OrderDiff";

    /**
     * 获取未支付的详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $orderDiffId, string $diffType, bool $showCancel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderDiffId" => $orderDiffId, "diffType" => $diffType, "showCancel" => $showCancel]);
    }

    /**
     * 取消未支付订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function cancel (int $orderId, int $orderDiffId, string $reason, string $diffType, int $inputStaffId, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reason" => $reason, "diffType" => $diffType, "inputStaffId" => $inputStaffId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * onTimeCloseNoPaidUpdateOrder
     * @return  void
    */
    public static function onTimeCloseNoPaidUpdateOrder () {
         RpcClass::getClass(self::$serviceName, self::$className)->onTimeCloseNoPaidUpdateOrder();
    }

    /**
     * 设置未支付的订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false, float $paymentMoney = null, array $extend = [], string $people = '', string $account = '', string $reason = '', int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway, "paymentMoney" => $paymentMoney, "extend" => $extend, "people" => $people, "account" => $account, "reason" => $reason, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 设置未支付的订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setZeroMoneyPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, int $operateId = 0, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setZeroMoneyPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 通过子订单号批量查询diff订单-数据同步
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrdersBySubOrderNos (array $subOrderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrdersBySubOrderNos(["subOrderNos" => $subOrderNos]);
    }

    /**
     * 获取未支付的详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getDiffType (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDiffType(["id" => $id]);
    }

    /**
     * 保存未支付的订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function saveDepositOrder (int $orderId, int $orderDiffId, int $operateId = 0, int $scheduleOperator = null, string $scheduleOperatorType = null, string $scheduleRequestOrigin = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveDepositOrder(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "operateId" => $operateId, "scheduleOperator" => $scheduleOperator, "scheduleOperatorType" => $scheduleOperatorType, "scheduleRequestOrigin" => $scheduleRequestOrigin]);
    }

    /**
     * 计算在订单系统中下单的零售需要支付的金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function calRetailNeedPaidMoney (int $orderDiffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calRetailNeedPaidMoney(["orderDiffId" => $orderDiffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}