<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-08 12:08:45
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GroupOrder
 * @method listByParams(array $params) 团购订单列表
 * @method createByParams(array $params) 创建订单
 * @method detailByParams(array $params) 订单详情
 * @method detailByNoByParams(array $params) 订单详情
 * @method detailByProductCardIdByParams(array $params) 根据产品卡id获取团购订单详情
 * @method getPreferentialByCardIdsByParams(array $params) 根据产品卡ids获取团购券码信息
 * @method paidByParams(array $params) 订单支付（全款与首款）
 * @method cancelByParams(array $params) 取消订单
 * @method reviewByParams(array $params) 订单审核
 * @method balanceEntryByParams(array $params) 支付尾款
 * @method getPhotoOrdersByParams(array $params) 获取关联拍摄订单
 * @method getAllOrderIdsByParams(array $params) 获取所有团购关联订单id
 * @method OrderProductByParams(array $params) 获取预约产品
 * @method deleteOrderProductByParams(array $params) 删除预约产品
 * @method getOrderProductByParams(array $params) 获取订单预约产品
 * @method addPreferentialByParams(array $params) 添加团购券码
 * @method decrementLeftNumByParams(array $params) 减少原始产品的剩余数量
 * @method updateTemplateIdByParams(array $params) 更新团购item的优惠模板id
 * @method addInvoiceInfoByParams(array $params) 增加团购单开票信息
 * @method finishPreferentialOrderByParams(array $params) 完成订单
 * @method getGroupOrderInfoByOrderIdByParams(array $params) 根据订单ID获取团购拍摄订单信息
 * @method getGroupOrderListByPayByParams(array $params) 根据支付信息获取团购订单列表
 * @method cancelOrdersByParams(array $params) 批量取消订单
 * @method closeOrdersByParams(array $params) 关闭未提取的团购订单
 * @method getExactGroupOrderBalanceByParams(array $params) 获取团购订单的余额
 * @method changePayTypeByParams(array $params) 修改团购订单的支付方式
 */
class GroupOrder {
    private static string $serviceName = "Order";

    private static string $className = "GroupOrder";

    /**
     * 团购订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 创建订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function detailByNo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNo($_params);
    }

    /**
     * 根据产品卡id获取团购订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function detailByProductCardId (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByProductCardId($_params);
    }

    /**
     * 根据产品卡ids获取团购券码信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPreferentialByCardIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialByCardIds($_params);
    }

    /**
     * 订单支付（全款与首款）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function paid (int $id, string $pay_type, string $paid_at, float $money, string $payment_no = '', string $type = '', array $certificates = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "pay_type" => $pay_type, "paid_at" => $paid_at, "money" => $money, "payment_no" => $payment_no, "type" => $type, "certificates" => $certificates]);
    }

    /**
     * 取消订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function cancel (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id]);
    }

    /**
     * 订单审核
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function review (int $pay_id, string $action) {
        return RpcClass::getClass(self::$serviceName, self::$className)->review(["pay_id" => $pay_id, "action" => $action]);
    }

    /**
     * 支付尾款
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function balanceEntry (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceEntry($_params);
    }

    /**
     * 获取关联拍摄订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPhotoOrders (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoOrders($_params);
    }

    /**
     * 获取所有团购关联订单id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllOrderIds (int $store_id = 0, bool $with_del = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOrderIds(["store_id" => $store_id, "with_del" => $with_del]);
    }

    /**
     * 获取预约产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function OrderProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->OrderProduct(["id" => $id]);
    }

    /**
     * 删除预约产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteOrderProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrderProduct(["id" => $id]);
    }

    /**
     * 获取订单预约产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderProduct (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderProduct(["order_id" => $order_id]);
    }

    /**
     * 添加团购券码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addPreferential (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPreferential($_params);
    }

    /**
     * 减少原始产品的剩余数量
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function decrementLeftNum (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->decrementLeftNum($_params);
    }

    /**
     * 更新团购item的优惠模板id
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function updateTemplateId (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTemplateId($_params);
    }

    /**
     * 增加团购单开票信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addInvoiceInfo (string $order_no, int $invoice_id, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addInvoiceInfo(["order_no" => $order_no, "invoice_id" => $invoice_id, "money" => $money]);
    }

    /**
     * 完成订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function finishPreferentialOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPreferentialOrder(["id" => $id]);
    }

    /**
     * 根据订单ID获取团购拍摄订单信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getGroupOrderInfoByOrderId (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupOrderInfoByOrderId(["order_id" => $order_id]);
    }

    /**
     * 根据支付信息获取团购订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGroupOrderListByPay (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupOrderListByPay($_params);
    }

    /**
     * 批量取消订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelOrders (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrders(["ids" => $ids]);
    }

    /**
     * 关闭未提取的团购订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeOrders (array $ids, string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrders(["ids" => $ids, "reason" => $reason]);
    }

    /**
     * 获取团购订单的余额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  float
    */
    public static function getExactGroupOrderBalance (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExactGroupOrderBalance(["id" => $id]);
    }

    /**
     * 修改团购订单的支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changePayType (int $id, int $payId, string $payType, int $operateId, string $paymentNo = null, string $reason = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payId" => $payId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "reason" => $reason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}