<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-01-06 11:55:54
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RefundChange
 * @method createByParams(array $params) 创建转退
 * @method removeByParams(array $params) 删除转退
 * @method listByParams(array $params) 转退列表
 * @method detailByParams(array $params) 转退详情
 * @method passByParams(array $params) 通过转退
 * @method rejectByParams(array $params) 拒绝转退
 * @method getListByRefundIdsByParams(array $params) 批量获取转退列表
 * @method changeRefundAccountByParams(array $params) 修改转退账户信息
 */
class RefundChange {
    private static string $serviceName = "Order";

    private static string $className = "RefundChange";

    /**
     * 创建转退
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function create (int $refundId, string $people, string $account, string $reason, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["refundId" => $refundId, "people" => $people, "account" => $account, "reason" => $reason, "inputStaffId" => $inputStaffId]);
    }

    /**
     * 删除转退
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }

    /**
     * 转退列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 转退详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 通过转退
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function pass (int $id, int $operateId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, "operateId" => $operateId, "paymentNo" => $paymentNo]);
    }

    /**
     * 拒绝转退
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function reject (int $id, int $operateId, string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "operateId" => $operateId, "reason" => $reason]);
    }

    /**
     * 批量获取转退列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getListByRefundIds (array $refundIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByRefundIds(["refundIds" => $refundIds]);
    }

    /**
     * 修改转退账户信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeRefundAccount (int $id, string $people, string $account) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeRefundAccount(["id" => $id, "people" => $people, "account" => $account]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}