<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-21 16:31:03
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderRetake
 * @method createByParams(array $params) 创建重拍订单
 * @method getBaseRetakeInfoByParams(array $params) 获取重拍的基础信息
 * @method getBaseRetakeInfoListByOrderIdsByParams(array $params) 根据原订单ids，批量获取重拍的基础信息
 * @method getBaseRetakeInfoListByRetakeOrderIdsByParams(array $params) 根据重拍的订单ids，批量获取重拍的基础信息
 * @method cancelByParams(array $params) 取消重拍订单
 * @method reasonOptionsByParams(array $params) 退款原因选项
 * @method reasonDetailByParams(array $params) 退款原因详情
 */
class OrderRetake {
    private static string $serviceName = "Order";

    private static string $className = "OrderRetake";

    /**
     * 创建重拍订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 获取重拍的基础信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getBaseRetakeInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfo($_params);
    }
    /**
     * 根据原订单ids，批量获取重拍的基础信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getBaseRetakeInfoListByOrderIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfoListByOrderIds($_params);
    }
    /**
     * 根据重拍的订单ids，批量获取重拍的基础信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getBaseRetakeInfoListByRetakeOrderIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfoListByRetakeOrderIds($_params);
    }
    /**
     * 取消重拍订单
     * @return  mixed
    */
    public static function cancel (int $id, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "inputStaffId" => $inputStaffId]);
    }
    /**
     * 退款原因选项
     * @return  mixed
    */
    public static function reasonOptions () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonOptions([]);
    }
    /**
     * 退款原因详情
     * @return  mixed
    */
    public static function reasonDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}