<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-28 16:03:24
 */
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AfterSaleOrder
 * @method getReasonsByParams(array $params) 获取补偿申请原因
 * @method getUserStatisticsByParams(array $params) 获取用户售后统计数据
 * @method getStoreStatisticsByParams(array $params) 获取门店售后统计数据
 * @method getOrderStatisticsByParams(array $params) 获取订单售后统计数据
 * @method createByParams(array $params) 提交售后申请单
 * @method updateByParams(array $params) 更新售后单状态
 * @method detailByParams(array $params) 获取售后单详情
 * @method createEvaluationByParams(array $params) 售后评价
 * @method listByParams(array $params) 售后单列表
 * @method isAlreadyCreateAfterSaleByParams(array $params) 判断是否已存在售后单
 * @method getAfterSaleByOrderIdByParams(array $params) 使用海马体订单查询存在的售后单
 * @method getAfterSaleByProcessInstanceIdByParams(array $params) 通过审批实例id获取售后单信息
 * @method getAfterSaleSumInfoByParams(array $params) 使用海马体订单查询已申请的售后单汇总信息
 * @method allByParams(array $params) 根据订单ids查询售后单
 * @method dealResultByParams(array $params) 处理售后单结果
 */
class AfterSaleOrder {
    private static string $serviceName = "Order";

    private static string $className = "AfterSaleOrder\\AfterSaleOrder";

    /**
     * 获取补偿申请原因
     * @return  array
    */
    public static function getReasons () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReasons([]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ReasonTreeDTO[]"
        );
    }
    /**
     * 获取用户售后统计数据
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO
    */
    public static function getUserStatistics (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserStatistics(["userId" => $userId]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO"
        );
    }
    /**
     * 获取门店售后统计数据
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO
    */
    public static function getStoreStatistics (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreStatistics(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO"
        );
    }
    /**
     * 获取订单售后统计数据
     * @return  int
    */
    public static function getOrderStatistics (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStatistics(["orderId" => $orderId]);
    }
    /**
     * 提交售后申请单
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function create (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $createCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($createCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 更新售后单状态
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function update (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $updateCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update($updateCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 获取售后单详情
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 售后评价
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO
    */
    public static function createEvaluation (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $createEvalutionCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createEvaluation($createEvalutionCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO"
        );
    }
    /**
     * 售后单列表
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $listCommand = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO"
        );
    }
    /**
     * 判断是否已存在售后单
     * @return  bool
    */
    public static function isAlreadyCreateAfterSale (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isAlreadyCreateAfterSale(["orderId" => $orderId]);
    }
    /**
     * 使用海马体订单查询存在的售后单
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function getAfterSaleByOrderId (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByOrderId(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 通过审批实例id获取售后单信息
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function getAfterSaleByProcessInstanceId (string $processInstanceId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByProcessInstanceId(["processInstanceId" => $processInstanceId]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 使用海马体订单查询已申请的售后单汇总信息
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO
    */
    public static function getAfterSaleSumInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleSumInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO"
        );
    }
    /**
     * 根据订单ids查询售后单
     * @return  array
    */
    public static function all (?\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $allCommand = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all($allCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO[]"
        );
    }
    /**
     * 处理售后单结果
     * @return  bool
    */
    public static function dealResult (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dealResult(["id" => $id, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}