<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-22 15:28:43
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderSaleSku
 * @method serviceCompleteByParams(array $params) 服务完成
 * @method setLookPhotoCompleteByParams(array $params) 设置看片完成
 * @method clearLookPhotoCompletedAtByParams(array $params) 看片完成标记清除
 * @method listByParams(array $params) 获取订单的拍摄产品列表
 * @method removeByParams(array $params) 删除拍摄产品
 * @method getOrderSaleSkusNameByParams(array $params) 获取拍摄产品的名称
 * @method closeMantuOrderSaleSkuByParams(array $params) 关闭已支付的二销订单
 * @method updateUserSexByParams(array $params) 更改拍摄产品性别
 * @method setPhotoFinishedAtByParams(array $params) 设置照片交付时间
 * @method orderAllSkuListByParams(array $params) 订单所有购买过的sku和upgrade_sku信息
 */
class OrderSaleSku {
    private static string $serviceName = "Order";

    private static string $className = "OrderSaleSku";

    /**
     * 服务完成
     * @return  bool
    */
    public static function serviceComplete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete([]);
    }
    /**
     * 设置看片完成
     * @return  bool
    */
    public static function setLookPhotoComplete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setLookPhotoComplete([]);
    }
    /**
     * 看片完成标记清除
     * @return  mixed
    */
    public static function clearLookPhotoCompletedAt () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearLookPhotoCompletedAt([]);
    }
    /**
     * 获取订单的拍摄产品列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 删除拍摄产品
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }
    /**
     * 获取拍摄产品的名称
     * @return  mixed
    */
    public static function getOrderSaleSkusName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSaleSkusName(["ids" => $ids]);
    }
    /**
     * 关闭已支付的二销订单
     * @return  mixed
    */
    public static function closeMantuOrderSaleSku (int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMantuOrderSaleSku(["operateId" => $operateId]);
    }
    /**
     * 更改拍摄产品性别
     * @return  mixed
    */
    public static function updateUserSex () {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserSex([]);
    }
    /**
     * 设置照片交付时间
     * @return  array
    */
    public static function setPhotoFinishedAt (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoFinishedAt(["skuIds" => $skuIds]);
    }
    /**
     * 订单所有购买过的sku和upgrade_sku信息
     * @return  array
    */
    public static function orderAllSkuList (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAllSkuList(["orderIds" => $orderIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}