<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-28 15:34:56
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Turnover
 * @method listByParams(array $params) 订单的流水
 * @method orderTurnoverByParams(array $params) 订单的流水信息
 * @method changePayTypeByParams(array $params) 修改支付方式
 * @method listWithSaleTypeByParams(array $params) 获取流水信息及销售方式
 */
class Turnover {
    private static string $serviceName = "Order";

    private static string $className = "Turnover";

    /**
     * 订单的流水
     * @return  mixed
    */
    public static function list (string $orderType = 'order') {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderType" => $orderType]);
    }
    /**
     * 订单的流水信息
     * @return  array
    */
    public static function orderTurnover () {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderTurnover([]);
    }
    /**
     * 修改支付方式
     * @return  bool
    */
    public static function changePayType (int $id, string $orderType, string $payType, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "orderType" => $orderType, "payType" => $payType, "operateId" => $operateId]);
    }
    /**
     * 获取流水信息及销售方式
     * @return  mixed
    */
    public static function listWithSaleType (string $orderType = 'order') {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithSaleType(["orderType" => $orderType]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}