<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-04 10:42:00
 */
namespace Mainto\Bridge\Structs\Order\Refund\Command\CalcRefund;

class CalcRefundCommand {
    /**
     * @var  int
     * 订单的拍摄产品id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  bool
     * 是否包含删除的订单
     * validation: 
     */
    public bool $withDelete = false;
    /**
     * @var  string
     * 退款类型
     * validation: in:full_refund,part_refund,special_order_refund,special_sku_refund
     */
    public string $refundType = "part_refund";
    /**
     * @var  bool
     * 是否包含退款区间
     * validation: 
     */
    public bool $withAmountRange = false;
    /**
     * @var  \Mainto\Bridge\Structs\Order\Refund\Command\Common\RefundInfoCommand[]
     * 退款项(包含退款类型：order 订单 upgrade 升级服务)
     * validation: refundInfo|ChristmasMixProduct
     */
    public array $refundInfo;
    /**
     * @var  bool
     * 是否显示退款产品的原优惠信息
     * validation: 
     */
    public bool $withRefundItemsPreferential = false;
    /**
     * @var  bool
     * 是否显示修改的优惠信息
     * validation: 
     */
    public bool $withModifyPreferential = false;

    public function __construct (int $orderId = 0, array $refundInfo = []) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($refundInfo)) {
            $this->refundInfo = $refundInfo;
        }
    }

    public static function create(int $orderId = 0, array $refundInfo = []): self {
        return new self($orderId, $refundInfo);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setWithDelete(bool $withDelete): self {
        $this->withDelete = $withDelete;

        return $this;
    }

    public function setRefundType(string $refundType): self {
        $this->refundType = $refundType;

        return $this;
    }

    public function setWithAmountRange(bool $withAmountRange): self {
        $this->withAmountRange = $withAmountRange;

        return $this;
    }

    public function setRefundInfo(array $refundInfo): self {
        $this->refundInfo = $refundInfo;

        return $this;
    }

    public function setWithRefundItemsPreferential(bool $withRefundItemsPreferential): self {
        $this->withRefundItemsPreferential = $withRefundItemsPreferential;

        return $this;
    }

    public function setWithModifyPreferential(bool $withModifyPreferential): self {
        $this->withModifyPreferential = $withModifyPreferential;

        return $this;
    }
}