<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-13 14:36:18
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RefundV2
 */
class RefundV2 {
    private static string $serviceName = "Order";

    private static string $className = "RefundV2";

    /**
     * 创建退款
     *
     */
    public static function create (\Mainto\Bridge\Structs\Order\Refund\Command\CreateRefund\CreateRefundCommand $createRefundCommand): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createRefundCommand);
    }
    /**
     * 创建手续费退款并通过
     *
     */
    public static function createSurPlusRefundAndPass (\Mainto\Bridge\Structs\Order\Refund\Command\CreateRefund\CreateSurplusRefundCommand $createSurplusRefundCommand): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSurPlusRefundAndPass($createSurplusRefundCommand);
    }
    /**
     * 退款存疑数据通过
     *
     */
    public static function confirmRefundSuccess (int $refundId, int $refundMoneyDetailId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmRefundSuccess(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, ]);
    }
    /**
     * 退款存疑数据确认退款失败
     *
     */
    public static function confirmRefundError (int $refundId, int $refundMoneyDetailId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmRefundError(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, ]);
    }
    /**
     * 退款存疑的数据手动退款成功
     *
     */
    public static function confirmManualRefundPass (int $refundId, int $refundMoneyDetailId, string $paymentNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmManualRefundPass(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 退款存疑数据批量通过
     *
     */
    public static function confirmRefundListSuccess (int $refundId, array $refundMoneyDetailIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmRefundListSuccess(["refundId" => $refundId, "refundMoneyDetailIds" => $refundMoneyDetailIds, ]);
    }
    /**
     * 退款存疑数据批量确认退款失败
     *
     */
    public static function confirmRefundListError (int $refundId, array $refundMoneyDetailIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmRefundListError(["refundId" => $refundId, "refundMoneyDetailIds" => $refundMoneyDetailIds, ]);
    }
    /**
     * 退款存疑的数据手动退款成功批量设置
     *
     */
    public static function confirmManualRefundListPass (int $refundId, array $refundMoneyDetailIds, string $paymentNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmManualRefundListPass(["refundId" => $refundId, "refundMoneyDetailIds" => $refundMoneyDetailIds, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 手动退款成功
     *
     */
    public static function manualRefundPass (int $refundId, int $refundMoneyDetailId, string $paymentNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualRefundPass(["refundId" => $refundId, "refundMoneyDetailId" => $refundMoneyDetailId, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 手动退款批量操作成功
     *
     */
    public static function manualRefundListPass (int $refundId, array $refundMoneyDetailIds, string $paymentNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualRefundListPass(["refundId" => $refundId, "refundMoneyDetailIds" => $refundMoneyDetailIds, "paymentNo" => $paymentNo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}