<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-20 17:02:15
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Refund
 */
class Refund {
    private static string $serviceName = "Order";

    private static string $className = "Refund";

    /**
     * 退款原因选项
     */
    public static function reasonOptions (string $category = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonOptions(["category" => $category, ]);
    }
    /**
     * 退款原因详情
     */
    public static function reasonDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonDetail(["id" => $id, ]);
    }
    /**
     * 退款列表
     */
    public static function list (int $orderId, array $orderIds, string $status, array $statusList, int $storeId, array $storeIds, string $orderPayType, string $applyTimeStart, string $applyTimeEnd, string $processTimeStart, string $processTimeEnd, string $completeTimeStart, string $completeTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderId" => $orderId, "orderIds" => $orderIds, "status" => $status, "statusList" => $statusList, "storeId" => $storeId, "storeIds" => $storeIds, "orderPayType" => $orderPayType, "applyTimeStart" => $applyTimeStart, "applyTimeEnd" => $applyTimeEnd, "processTimeStart" => $processTimeStart, "processTimeEnd" => $processTimeEnd, "completeTimeStart" => $completeTimeStart, "completeTimeEnd" => $completeTimeEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 手续费剩余退款列表
     */
    public static function surplusRefundList (int $orderId, array $orderIds, string $status, array $statusList, int $storeId, array $storeIds, string $applyTimeStart, string $applyTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->surplusRefundList(["orderId" => $orderId, "orderIds" => $orderIds, "status" => $status, "statusList" => $statusList, "storeId" => $storeId, "storeIds" => $storeIds, "applyTimeStart" => $applyTimeStart, "applyTimeEnd" => $applyTimeEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 退款详情
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 根据订单ID获取退款列表
     */
    public static function getAllRefundListByOrderId (int $orderId, string $orderType = null, string $type = 'all_refund') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRefundListByOrderId(["orderId" => $orderId, "orderType" => $orderType, "type" => $type, ]);
    }
    /**
     * 通过退款
     */
    public static function pass (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, ]);
    }
    /**
     * 通过退款
     */
    public static function passChangeRefund (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passChangeRefund(["id" => $id, ]);
    }
    /**
     * 修改信息
     */
    public static function modifyInfo (int $id, int $operateId, string $people = null, string $account = null, array $extend = null): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyInfo(["id" => $id, "operateId" => $operateId, "people" => $people, "account" => $account, "extend" => $extend, ]);
    }
    /**
     * 删除退款
     */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, ]);
    }
    /**
     * 拒绝退款
     */
    public static function reject (int $id, string $reason = ''): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "reason" => $reason, ]);
    }
    /**
     * 重新申请退款
     */
    public static function reapply (int $id, string $people, string $account, string $reason, int $inputStaffId, int $scale = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->reapply(["id" => $id, "people" => $people, "account" => $account, "reason" => $reason, "inputStaffId" => $inputStaffId, "scale" => $scale, ]);
    }
    /**
     * 修正退款结果
     */
    public static function fixRefundResult (int $id, float $autoRealMoney): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixRefundResult(["id" => $id, "autoRealMoney" => $autoRealMoney, ]);
    }
    /**
     * 获取订单的退款相关信息
     */
    public static function getOrderRefundInfo (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderRefundInfo(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单的可退手续费信息
     */
    public static function getOrderSurplusRefundList (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSurplusRefundList(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}