<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-18 19:22:27
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderV2
 */
class OrderV2 {
    private static string $serviceName = "Order";

    private static string $className = "OrderV2";

    /**
     * 关闭网关支付订单
     * @return  mixed
    */
    public static function closePaymentAwayOrder (int $id, string $reason, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closePaymentAwayOrder(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }
    /**
     * 关闭订单的产品卡信息
     * @return  bool
    */
    public static function closeOrderProductCard (int $id, int $productCardId, string $reason, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrderProductCard(["id" => $id, "productCardId" => $productCardId, "reason" => $reason, "operateId" => $operateId]);
    }
    /**
     * 批量关闭订单的产品卡信息
     * @return  array
    */
    public static function batchCloseOrderProductCard (\Mainto\Bridge\Structs\Order\Order\Command\BatchCloseOrderProductCardCommand $batchCloseOrderProductCardCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCloseOrderProductCard($batchCloseOrderProductCardCommand);
    }
    /**
     * 获取订单信息（现包含支付等信息用于财务中台核算处理）
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Info\OrderInfoDTO
    */
    public static function orderInfo (int $id = 0, string $orderNo = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderInfo(["id" => $id, "orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Info\OrderInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}