<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-21 11:09:32
 */
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AfterSaleOrder
 */
class AfterSaleOrder {
    private static string $serviceName = "Order";

    private static string $className = "AfterSaleOrder\\AfterSaleOrder";

    /**
     * 获取补偿申请原因
     */
    public static function getReasons (string $type = 'preferential', bool $withDel = false): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReasons(["type" => $type, "withDel" => $withDel, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ReasonTreeDTO[]"
        );
    }
    /**
     * 获取用户售后统计数据
     */
    public static function getUserStatistics (int $userId, string $type = 'preferential'): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserStatistics(["userId" => $userId, "type" => $type, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO"
        );
    }
    /**
     * 获取门店售后统计数据
     */
    public static function getStoreStatistics (int $storeId, string $type = 'preferential'): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreStatistics(["storeId" => $storeId, "type" => $type, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO"
        );
    }
    /**
     * 获取订单售后统计数据
     */
    public static function getOrderStatistics (int $orderId, string $type = 'preferential'): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStatistics(["orderId" => $orderId, "type" => $type, ]);
    }
    /**
     * 提交售后申请单
     */
    public static function create (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $createCommand): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($createCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 更新售后单状态
     */
    public static function update (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $updateCommand): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update($updateCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 获取售后单详情
     */
    public static function detail (int $id): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 售后评价
     */
    public static function createEvaluation (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $createEvalutionCommand): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createEvaluation($createEvalutionCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO"
        );
    }
    /**
     * 售后单列表
     */
    public static function list (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $listCommand): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO"
        );
    }
    /**
     * 判断是否已存在售后单
     */
    public static function isAlreadyCreateAfterSale (int $orderId, string $type = 'preferential'): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isAlreadyCreateAfterSale(["orderId" => $orderId, "type" => $type, ]);
    }
    /**
     * 使用海马体订单查询存在的售后单
     */
    public static function getAfterSaleByOrderId (int $orderId, string $type = 'preferential'): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByOrderId(["orderId" => $orderId, "type" => $type, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 通过审批实例id获取售后单信息
     */
    public static function getAfterSaleByProcessInstanceId (string $processInstanceId, string $status = null, string $type = null): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByProcessInstanceId(["processInstanceId" => $processInstanceId, "status" => $status, "type" => $type, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 使用海马体订单查询已申请的售后单汇总信息
     */
    public static function getAfterSaleSumInfo (int $orderId, string $type = 'preferential', array $statusArr = []): \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleSumInfo(["orderId" => $orderId, "type" => $type, "statusArr" => $statusArr, ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO"
        );
    }
    /**
     * 根据订单ids查询售后单
     */
    public static function all (?\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $allCommand = null): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all($allCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}