<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-03 11:47:15
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "Order";

    private static string $className = "Order";

    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (int $storeId, int $userId, int $orderUserId, string $userName, string $userPhone, string $userSex, string $userBirthday, string $userEmail, string $from, string $channel, int $peopleNum, float $money, float $realMoney, array $productInfo, array $reachedInfo, array $globalDiscountIds, float $globalDiscountMoney, array $packageDiscountIds, float $packageDiscountMoney, float $businessDiscountMoney, string $interiorCouponCode, float $interiorCouponDeductionMoney, array $couponInfo, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, int $specialDiscountStaffId, string $discountNote, string $discountType, float $peopleDiscountMoney, float $giftCardPayMoney, float $marketCardMoney, string $reserveTime, int $occupyNum, array $occupyIndexs, string $module, string $type, int $inputStaffId, array $extend, string $paymentMethod = 'full_amount', float $depositMoney, float $balanceMoney, bool $setReservation = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["storeId" => $storeId, "userId" => $userId, "orderUserId" => $orderUserId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "userEmail" => $userEmail, "from" => $from, "channel" => $channel, "peopleNum" => $peopleNum, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "reachedInfo" => $reachedInfo, "globalDiscountIds" => $globalDiscountIds, "globalDiscountMoney" => $globalDiscountMoney, "packageDiscountIds" => $packageDiscountIds, "packageDiscountMoney" => $packageDiscountMoney, "businessDiscountMoney" => $businessDiscountMoney, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponInfo" => $couponInfo, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "specialDiscountStaffId" => $specialDiscountStaffId, "discountNote" => $discountNote, "discountType" => $discountType, "peopleDiscountMoney" => $peopleDiscountMoney, "giftCardPayMoney" => $giftCardPayMoney, "marketCardMoney" => $marketCardMoney, "reserveTime" => $reserveTime, "occupyNum" => $occupyNum, "occupyIndexs" => $occupyIndexs, "module" => $module, "type" => $type, "inputStaffId" => $inputStaffId, "extend" => $extend, "paymentMethod" => $paymentMethod, "depositMoney" => $depositMoney, "balanceMoney" => $balanceMoney, "setReservation" => $setReservation]);
    }
    /**
     * 创建订单——忽略占点信息
     * @return  array
    */
    public static function createIgnoreOccupyNum (int $storeId, int $userId, int $orderUserId, string $userName, string $userPhone, string $userSex, string $userBirthday, string $userEmail, string $from, string $channel, int $peopleNum, float $money, float $realMoney, array $productInfo, array $reachedInfo, array $globalDiscountIds, float $globalDiscountMoney, array $packageDiscountIds, float $packageDiscountMoney, float $businessDiscountMoney, string $interiorCouponCode, float $interiorCouponDeductionMoney, array $couponInfo, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, int $specialDiscountStaffId, string $discountNote, string $discountType, float $peopleDiscountMoney, float $giftCardPayMoney, float $marketCardMoney, string $reserveTime, int $occupyNum, array $occupyIndexs, string $module, string $type, int $inputStaffId, array $extend, string $paymentMethod = 'full_amount', float $depositMoney, float $balanceMoney, bool $setReservation = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createIgnoreOccupyNum(["storeId" => $storeId, "userId" => $userId, "orderUserId" => $orderUserId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "userEmail" => $userEmail, "from" => $from, "channel" => $channel, "peopleNum" => $peopleNum, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "reachedInfo" => $reachedInfo, "globalDiscountIds" => $globalDiscountIds, "globalDiscountMoney" => $globalDiscountMoney, "packageDiscountIds" => $packageDiscountIds, "packageDiscountMoney" => $packageDiscountMoney, "businessDiscountMoney" => $businessDiscountMoney, "interiorCouponCode" => $interiorCouponCode, "interiorCouponDeductionMoney" => $interiorCouponDeductionMoney, "couponInfo" => $couponInfo, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "specialDiscountStaffId" => $specialDiscountStaffId, "discountNote" => $discountNote, "discountType" => $discountType, "peopleDiscountMoney" => $peopleDiscountMoney, "giftCardPayMoney" => $giftCardPayMoney, "marketCardMoney" => $marketCardMoney, "reserveTime" => $reserveTime, "occupyNum" => $occupyNum, "occupyIndexs" => $occupyIndexs, "module" => $module, "type" => $type, "inputStaffId" => $inputStaffId, "extend" => $extend, "paymentMethod" => $paymentMethod, "depositMoney" => $depositMoney, "balanceMoney" => $balanceMoney, "setReservation" => $setReservation]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withRefund" => $withRefund, "withModifyRefund" => $withModifyRefund]);
    }
    /**
     * 订单详情V2
     * @return  mixed
    */
    public static function detailV2 (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false, bool $withTurnover = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailV2(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withRefund" => $withRefund, "withModifyRefund" => $withModifyRefund, "withTurnover" => $withTurnover]);
    }
    /**
     * 取消订单——主订单
     * @return  mixed
    */
    public static function cancel (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "reason" => $reason]);
    }
    /**
     * 使用数据库查询订单
     * @return  mixed
    */
    public static function searchUseDb (array $orderIds, array $notInOrderIds, array $orderNos, array $storeIds, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, int $page, int $pageSize, string $sortField, bool $sortDesc, bool $withDel, bool $withRefund = false, array $customerCareTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUseDb(["orderIds" => $orderIds, "notInOrderIds" => $notInOrderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "withRefund" => $withRefund, "customerCareTypes" => $customerCareTypes]);
    }
    /**
     * 使用ES查询订单
     * @return  mixed
    */
    public static function searchUseEs (array $orderIds, array $orderNos, array $storeIds, string $origin, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, array $neqStatusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, string $lastUserPhone, int $page, int $pageSize, string $sortField, bool $sortDesc, bool $withDel, bool $withRefund = false, array $customerCareTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUseEs(["orderIds" => $orderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "origin" => $origin, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "neqStatusList" => $neqStatusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "lastUserPhone" => $lastUserPhone, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "withRefund" => $withRefund, "customerCareTypes" => $customerCareTypes]);
    }
    /**
     * 获取门店等待签到的数据
     * @return  mixed
    */
    public static function getStoreWaitSignNum (int $storeId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreWaitSignNum(["storeId" => $storeId, "reserveTime" => $reserveTime]);
    }
    /**
     * 删除订单
     * @return  mixed
    */
    public static function remove (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 用户删除订单
     * @return  mixed
    */
    public static function deleteByUser (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteByUser(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 关闭订单
     * @return  mixed
    */
    public static function close (int $id, string $reason, int $operateId, string $note = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "reason" => $reason, "operateId" => $operateId, "note" => $note]);
    }
    /**
     * 关闭美团订单
     * @return  mixed
    */
    public static function closeMeiTuanOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMeiTuanOrder(["id" => $id]);
    }
    /**
     * 关闭缦图订单
     * @return  mixed
    */
    public static function closeMantuOrder (int $id, string $reason = '', int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeMantuOrder(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }
    /**
     * 修改使用礼品卡金额
     * @return  mixed
    */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useGiftCardMoney(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney]);
    }
    /**
     * 给已提交的订单使用礼品卡支付
     * @return  mixed
    */
    public static function giftCardPrePay (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPrePay(["id" => $id]);
    }
    /**
     * 商场卡支付改价格
     * @return  mixed
    */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useMarketCardMoney(["id" => $id, "marketCardMoney" => $marketCardMoney]);
    }
    /**
     * 设置订单完成支付——新建订单
     * @return  array
    */
    public static function setPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false, float $paymentMoney = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway, "paymentMoney" => $paymentMoney]);
    }
    /**
     * 设置零元支付订单完成支付——新建订单
     * @return  array
    */
    public static function setZeroMoneyPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setZeroMoneyPaid(["id" => $id, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId]);
    }
    /**
     * 开始订单
     * @return  mixed
    */
    public static function start (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->start(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 门店完成无纸化操作（化妆师和摄影师）
     * @return  mixed
    */
    public static function finishPaperless (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPaperless(["id" => $id]);
    }
    /**
     * 门店完成订单
     * @return  mixed
    */
    public static function finish (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 门店录入工作量
     * @return  bool
    */
    public static function setOrderWorkloads (int $id, array $workloads, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderWorkloads(["id" => $id, "workloads" => $workloads, "operateId" => $operateId]);
    }
    /**
     * 获取工作量
     * @return  mixed
    */
    public static function getPaperlessWorkloads (int $id, array $staffTypes = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessWorkloads(["id" => $id, "staffTypes" => $staffTypes]);
    }
    /**
     * 批量获取工作量
     * @return  mixed
    */
    public static function getPaperlessWorkloadsList (array $ids, array $staffTypes = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessWorkloadsList(["ids" => $ids, "staffTypes" => $staffTypes]);
    }
    /**
     * 完成看片
     * @return  bool
    */
    public static function completeLookPhoto (int $id, int $staffId = 0, int $workPer = 0, string $type = 'user', int $storeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->completeLookPhoto(["id" => $id, "staffId" => $staffId, "workPer" => $workPer, "type" => $type, "storeId" => $storeId]);
    }
    /**
     * 服务整体完成（用户确认服务完成）
     * @return  bool
    */
    public static function serviceComplete (int $id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete(["id" => $id, "type" => $type]);
    }
    /**
     * 修改预约时间
     * @return  mixed
    */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId, string $note = '', int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeReserveTime(["id" => $id, "reserveTime" => $reserveTime, "operateId" => $operateId, "note" => $note, "occupyNum" => $occupyNum, "from" => $from, "occupyIndexs" => $occupyIndexs]);
    }
    /**
     * 看片自动确认标记清除
     * @return  mixed
    */
    public static function clearConfirmation (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearConfirmation(["id" => $id]);
    }
    /**
     * 根据订单id查询自动看片完成信息
     * @return  mixed
    */
    public static function getConfirmationByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getConfirmationByIds(["ids" => $ids]);
    }
    /**
     * 改变订单的看片预约时间
     * @return  array
    */
    public static function changeLookPhotoReserveTime (int $id, int $operateId, string $lookPhotoReserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeLookPhotoReserveTime(["id" => $id, "operateId" => $operateId, "lookPhotoReserveTime" => $lookPhotoReserveTime]);
    }
    /**
     * 恢复到等待拍摄状态
     * @return  array
    */
    public static function recoverWaitShooting (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverWaitShooting(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 把完成的订单恢复到等待拍摄
     * @return  mixed
    */
    public static function recoverFinishedToWaitShooting (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverFinishedToWaitShooting(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 获取门店下订单不同状态数量【专供缦图订单接口】
     * @return  mixed
    */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStatus(["storeId" => $storeId, "module" => $module, "needToday" => $needToday]);
    }
    /**
     * 根据订单号获取订单ID
     * @return  mixed
    */
    public static function getIdByNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["orderNo" => $orderNo]);
    }
    /**
     * 根据订单ID获取订单号
     * @return  mixed
    */
    public static function getNoById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoById(["id" => $id]);
    }
    /**
     * 绑定用户
     * @return  array
    */
    public static function bindUser (int $id, int $userId, string $userPhone, bool $force = false, int $operateId = 0, string $bindReason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUser(["id" => $id, "userId" => $userId, "userPhone" => $userPhone, "force" => $force, "operateId" => $operateId, "bindReason" => $bindReason]);
    }
    /**
     * 解绑用户
     * @return  array
    */
    public static function unbindUser (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindUser(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 批量更新订单的发票ID
     * @return  mixed
    */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateInvoiceId(["invoiceId" => $invoiceId, "orderNos" => $orderNos]);
    }
    /**
     * 计算订单消费金额
     * @return  mixed
    */
    public static function getOrderConsumeMoney (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderConsumeMoney(["id" => $id]);
    }
    /**
     * 查看订单操作日志
     * @return  mixed
    */
    public static function getOrderOperateLog (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOperateLog(["orderId" => $orderId]);
    }
    /**
     * 批量查看订单操作日志
     * @return  mixed
    */
    public static function batchGetOrdersOperateLog (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetOrdersOperateLog(["orderIds" => $orderIds]);
    }
    /**
     * 获取订单某操作记录次数
     * @return  mixed
    */
    public static function getOrderOperateLogCount (int $orderId, array $actions, bool $includeTransfer = false, string $from = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOperateLogCount(["orderId" => $orderId, "actions" => $actions, "includeTransfer" => $includeTransfer, "from" => $from]);
    }
    /**
     * 修改用户数据
     * @return  mixed
    */
    public static function changeUserData (int $id, string $userName = null, string $userSex = null, string $userEmail = null, string $userBirthday = null, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "userName" => $userName, "userSex" => $userSex, "userEmail" => $userEmail, "userBirthday" => $userBirthday, "operateId" => $operateId]);
    }
    /**
     * 转换门店
     * @return  mixed
    */
    public static function changeStore (int $id, int $storeId, string $reserveTime, int $operateId, int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = [], bool $setReservation = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStore(["id" => $id, "storeId" => $storeId, "reserveTime" => $reserveTime, "operateId" => $operateId, "occupyNum" => $occupyNum, "from" => $from, "occupyIndexs" => $occupyIndexs, "setReservation" => $setReservation]);
    }
    /**
     * 根据门店查询二销
     * @return  mixed
    */
    public static function queryDsListWithStore (int $staffId, string $startTime, string $endTime, int $dsModel = 2, int $storeId = 0, bool $withUpgrade = true, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryDsListWithStore(["staffId" => $staffId, "startTime" => $startTime, "endTime" => $endTime, "dsModel" => $dsModel, "storeId" => $storeId, "withUpgrade" => $withUpgrade, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 根据订单号获取订单下面买的产品
     * @return  mixed
    */
    public static function getProductsInOrder (string $orderNo = '', int $orderId = 0, int $orderSaleId = null, bool $withDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrder(["orderNo" => $orderNo, "orderId" => $orderId, "orderSaleId" => $orderSaleId, "withDeleted" => $withDeleted]);
    }
    /**
     * 根据订单号批量获取订单下面买的产品
     * @return  mixed
    */
    public static function getProductsInOrders (array $orderNos = [], array $orderIds = [], bool $withDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrders(["orderNos" => $orderNos, "orderIds" => $orderIds, "withDeleted" => $withDeleted]);
    }
    /**
     * 修改订单extend数据
     * @return  mixed
    */
    public static function changeExtend (int $id, string $note, string $noPaperNote, int $modifyCount, int $operateId, string $partRefundTime, string $appointLookPhotoSource, string $outsideCity, string $outsideAddress, string $groupName, int $groupId, string $paperlessNote, string $firstWatchFinishType, array $sendMemberCoupons, array $birthGiftInfo, array $newYearWishInfo, string $discountNote, string $stageName, string $weddingDay, string $mantuSpecialTag, string $mantuJoinTime, string $mantuChannel, array $peoplePhotos, bool $commissionTag) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeExtend(["id" => $id, "note" => $note, "noPaperNote" => $noPaperNote, "modifyCount" => $modifyCount, "operateId" => $operateId, "partRefundTime" => $partRefundTime, "appointLookPhotoSource" => $appointLookPhotoSource, "outsideCity" => $outsideCity, "outsideAddress" => $outsideAddress, "groupName" => $groupName, "groupId" => $groupId, "paperlessNote" => $paperlessNote, "firstWatchFinishType" => $firstWatchFinishType, "sendMemberCoupons" => $sendMemberCoupons, "birthGiftInfo" => $birthGiftInfo, "newYearWishInfo" => $newYearWishInfo, "discountNote" => $discountNote, "stageName" => $stageName, "weddingDay" => $weddingDay, "mantuSpecialTag" => $mantuSpecialTag, "mantuJoinTime" => $mantuJoinTime, "mantuChannel" => $mantuChannel, "peoplePhotos" => $peoplePhotos, "commissionTag" => $commissionTag]);
    }
    /**
     * 设置拍摄订单签到
     * @return  mixed
    */
    public static function userReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "inputStaffId" => $inputStaffId, "needMoney" => $needMoney, "money" => $money]);
    }
    /**
     * 拍摄签到详情
     * @return  mixed
    */
    public static function getUserReachedDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserReachedDetail(["orderId" => $orderId]);
    }
    /**
     * 修改拍摄订单签到
     * @return  mixed
    */
    public static function modifyUserReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyUserReached(["orderId" => $orderId, "reachedPeopleNum" => $reachedPeopleNum, "inputStaffId" => $inputStaffId, "needMoney" => $needMoney, "money" => $money]);
    }
    /**
     * 取消拍摄签到
     * @return  bool
    */
    public static function cancelUserReached (int $orderId, int $orderDiffId, int $inputStaffId, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelUserReached(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "inputStaffId" => $inputStaffId, "reason" => $reason]);
    }
    /**
     * 设置签到完成支付
     * @return  mixed
    */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserReachedPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway]);
    }
    /**
     * 获取门店订单完成数量
     * @return  mixed
    */
    public static function getStoreFinishOrderCount (string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreFinishOrderCount(["startDate" => $startDate, "endDate" => $endDate]);
    }
    /**
     * 设置订单的无纸化完成
     * @return  mixed
    */
    public static function setOrderPaperlessFinish (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderPaperlessFinish(["id" => $id]);
    }
    /**
     * 获取订单可开发票信息接口
     * @return  array
    */
    public static function getInvoiceList (int $storeId, int $userId, string $userPhone, int $orderId, array $orderIds, string $orderNo, array $orderNos, string $status, array $statusList, string $type, array $typeList, string $module, string $createTimeStart, string $createTimeEnd, string $sortField = 'id', array $sortEnums, bool $sortDesc = true, int $page, int $pageSize, bool $hasBeenInvoiced) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvoiceList(["storeId" => $storeId, "userId" => $userId, "userPhone" => $userPhone, "orderId" => $orderId, "orderIds" => $orderIds, "orderNo" => $orderNo, "orderNos" => $orderNos, "status" => $status, "statusList" => $statusList, "type" => $type, "typeList" => $typeList, "module" => $module, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "sortField" => $sortField, "sortEnums" => $sortEnums, "sortDesc" => $sortDesc, "page" => $page, "pageSize" => $pageSize, "hasBeenInvoiced" => $hasBeenInvoiced]);
    }
    /**
     * 获取订单可开发票信息接口
     * @return  array
    */
    public static function getInvoiceAll (int $storeId, int $userId, string $userPhone, int $orderId, array $orderIds, string $orderNo, array $orderNos, string $status, array $statusList, string $type, array $typeList, string $module, string $createTimeStart, string $createTimeEnd, string $sortField = 'id', array $sortEnums, bool $sortDesc = true, bool $hasBeenInvoiced) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvoiceAll(["storeId" => $storeId, "userId" => $userId, "userPhone" => $userPhone, "orderId" => $orderId, "orderIds" => $orderIds, "orderNo" => $orderNo, "orderNos" => $orderNos, "status" => $status, "statusList" => $statusList, "type" => $type, "typeList" => $typeList, "module" => $module, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "sortField" => $sortField, "sortEnums" => $sortEnums, "sortDesc" => $sortDesc, "hasBeenInvoiced" => $hasBeenInvoiced]);
    }
    /**
     * 获取上个月门店订单完成数量
     * @return  mixed
    */
    public static function getStoreOrderCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOrderCount();
    }
    /**
     * 根据看片时间获取未设置完成服务的拍摄产品
     * @return  mixed
    */
    public static function getOrderUnSetServiceComplete (string $lookPhotoTimeStart, string $lookPhotoTimeEnd, string $orderType, int $page, int $pageSize, string $sortField, bool $sortDesc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderUnSetServiceComplete(["lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "orderType" => $orderType, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc]);
    }
    /**
     * 查询订单编号
     * @return  mixed
    */
    public static function searchOrderNo (array $storeIds, array $productIds, string $createTimeStart, string $createTimeEnd, int $userId, string $status, array $statusList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderNo(["storeIds" => $storeIds, "productIds" => $productIds, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "userId" => $userId, "status" => $status, "statusList" => $statusList]);
    }
    /**
     * 获取预约看片信息
     * @return  array
    */
    public static function getOrderLookPhotoReserveLit (array $storeIds, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderLookPhotoReserveLit(["storeIds" => $storeIds, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 根据订单Ids批量获取订单号
     * @return  mixed
    */
    public static function getOrderNosByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderNosByIds(["ids" => $ids]);
    }
    /**
     * 获取订单的拍摄产品和升级服务产品
     * @return  mixed
    */
    public static function getOrderSaleSkuAndUpgradeSku (int $orderId, array $orderIds, string $orderNo, array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSaleSkuAndUpgradeSku(["orderId" => $orderId, "orderIds" => $orderIds, "orderNo" => $orderNo, "orderNos" => $orderNos]);
    }
    /**
     * 获取订单是否绑定用户
     * @return  mixed
    */
    public static function isBindUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isBindUser(["id" => $id]);
    }
    /**
     * 获取拍摄产品的订单
     * @return  array
    */
    public static function getProductOrders (int $userId, array $productIds, int $storeId, array $statusList, string $sortField, bool $sortDesc, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrders(["userId" => $userId, "productIds" => $productIds, "storeId" => $storeId, "statusList" => $statusList, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel]);
    }
    /**
     * 获取拍摄产品的订单——分页
     * @return  array
    */
    public static function getProductOrderList (int $userId, array $productIds, array $statusList, int $pageSize, int $page, string $sortField, bool $sortDesc, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrderList(["userId" => $userId, "productIds" => $productIds, "statusList" => $statusList, "pageSize" => $pageSize, "page" => $page, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel]);
    }
    /**
     * 查询订单及其所有的拍摄产品信息
     * @return  array
    */
    public static function searchOrdersWithAllSkus (array $orderIds, array $orderNos, array $storeIds, string $origin, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, array $neqStatusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, int $page, int $pageSize, string $sortField, bool $sortDesc, bool $withDel, bool $withRefund = false, array $customerCareTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrdersWithAllSkus(["orderIds" => $orderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "origin" => $origin, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "neqStatusList" => $neqStatusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "withRefund" => $withRefund, "customerCareTypes" => $customerCareTypes]);
    }
    /**
     * 查询订单及其所有的拍摄产品信息——使用db
     * @return  array
    */
    public static function searchOrdersWithAllSkusUseDb (array $orderIds, array $notInOrderIds, array $orderNos, array $storeIds, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, int $page, int $pageSize, string $sortField, bool $sortDesc, bool $withDel, bool $withRefund = false, array $customerCareTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrdersWithAllSkusUseDb(["orderIds" => $orderIds, "notInOrderIds" => $notInOrderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "withRefund" => $withRefund, "customerCareTypes" => $customerCareTypes]);
    }
    /**
     * 转门店带零售订单
     * @return  mixed
    */
    public static function retailOrderHookChangeStore (int $orderId, int $newStoreId, int $newOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOrderHookChangeStore(["orderId" => $orderId, "newStoreId" => $newStoreId, "newOrderId" => $newOrderId]);
    }
    /**
     * 查询订单以及拍摄产品信息
     * @return  array
    */
    public static function searchOrderWithSku (array $orderIds, array $orderNos, array $storeIds, string $origin, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, array $neqStatusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, int $page, int $pageSize, string $sortField, bool $sortDesc, bool $withDel, bool $withModifyClosed = false, array $customerCareTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderWithSku(["orderIds" => $orderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "origin" => $origin, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "neqStatusList" => $neqStatusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "withModifyClosed" => $withModifyClosed, "customerCareTypes" => $customerCareTypes]);
    }
    /**
     * 获取用户可开发票的门店列表
     * @return  array
    */
    public static function getUserInvoiceStoreList (int $userId, string $userPhone, string $status, array $statusList, string $type, array $typeList, string $module, bool $hasBeenInvoiced) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInvoiceStoreList(["userId" => $userId, "userPhone" => $userPhone, "status" => $status, "statusList" => $statusList, "type" => $type, "typeList" => $typeList, "module" => $module, "hasBeenInvoiced" => $hasBeenInvoiced]);
    }
    /**
     * 获取用户订单所在门店
     * @return  mixed
    */
    public static function getOrderStoreIdsByUserId (int $userId, array $statusList = [], bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStoreIdsByUserId(["userId" => $userId, "statusList" => $statusList, "withDel" => $withDel]);
    }
    /**
     * 获取用户已开票订单
     * @return  mixed
    */
    public static function getAlreadyInvoiceOrderByUserId (int $userId, array $statusList = [], string $module = 'himo', bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAlreadyInvoiceOrderByUserId(["userId" => $userId, "statusList" => $statusList, "module" => $module, "withDel" => $withDel]);
    }
    /**
     * 批量查询订单基础信息
     * @return  mixed
    */
    public static function searchOrderBasic (array $orderIds, array $orderNos, array $storeIds, string $origin, string $reserveTimeStart, string $reserveTimeEnd, string $lookPhotoReserveTimeStart, string $lookPhotoReserveTimeEnd, string $createTimeStart, string $createTimeEnd, string $lookPhotoTimeStart, string $lookPhotoTimeEnd, array $userIds, string $status, array $statusList, array $neqStatusList, bool $hasLookPhotoCompleteAt, string $userName, string $module, array $modules, string $type, string $userPhone, string $sortField, bool $sortDesc, bool $withDel, array $customerCareTypes, bool $withSku) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrderBasic(["orderIds" => $orderIds, "orderNos" => $orderNos, "storeIds" => $storeIds, "origin" => $origin, "reserveTimeStart" => $reserveTimeStart, "reserveTimeEnd" => $reserveTimeEnd, "lookPhotoReserveTimeStart" => $lookPhotoReserveTimeStart, "lookPhotoReserveTimeEnd" => $lookPhotoReserveTimeEnd, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "lookPhotoTimeStart" => $lookPhotoTimeStart, "lookPhotoTimeEnd" => $lookPhotoTimeEnd, "userIds" => $userIds, "status" => $status, "statusList" => $statusList, "neqStatusList" => $neqStatusList, "hasLookPhotoCompleteAt" => $hasLookPhotoCompleteAt, "userName" => $userName, "module" => $module, "modules" => $modules, "type" => $type, "userPhone" => $userPhone, "sortField" => $sortField, "sortDesc" => $sortDesc, "withDel" => $withDel, "customerCareTypes" => $customerCareTypes, "withSku" => $withSku]);
    }
    /**
     * 设置学生会员信息
     * @return  mixed
    */
    public static function setStudentMembership (int $orderId, string $studentMembership, bool $forcedRefresh = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStudentMembership(["orderId" => $orderId, "studentMembership" => $studentMembership, "forcedRefresh" => $forcedRefresh]);
    }
    /**
     * 清除学生会员信息
     * @return  mixed
    */
    public static function cleanStudentMembership (int $orderId, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanStudentMembership(["orderId" => $orderId, "operateId" => $operateId]);
    }
    /**
     * 订单基础详情
     * @return  mixed
    */
    public static function orderBasicDetail (int $id, string $orderNo, bool $withDelete, bool $withSku = false, bool $withModifyRefundSku = false, bool $withTurnover = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderBasicDetail(["id" => $id, "orderNo" => $orderNo, "withDelete" => $withDelete, "withSku" => $withSku, "withModifyRefundSku" => $withModifyRefundSku, "withTurnover" => $withTurnover]);
    }
    /**
     * 创建尾款支付
     * @return  array
    */
    public static function createOrderBalancePayment (int $id, float $paidMoney, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrderBalancePayment(["id" => $id, "paidMoney" => $paidMoney, "operateId" => $operateId]);
    }
    /**
     * 团购订单支付
     * @return  bool
    */
    public static function groupOrderPaid (int $orderId, int $orderDiffId, array $groupOrderItemIds, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupOrderPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "groupOrderItemIds" => $groupOrderItemIds, "inputStaffId" => $inputStaffId]);
    }
    /**
     * 获取订单的拍摄人数信息
     * @return  array
    */
    public static function orderPeoples (array $orderIds, array $orderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderPeoples(["orderIds" => $orderIds, "orderNos" => $orderNos]);
    }
    /**
     * 设置照片交付时间
     * @return  bool
    */
    public static function setPhotoFinishedAt (int $orderId, string $photoFinishedAt = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoFinishedAt(["orderId" => $orderId, "photoFinishedAt" => $photoFinishedAt]);
    }
    /**
     * 增加跳过化妆操作记录
     * @return  bool
    */
    public static function addOrderOperateSkipMakeup (int $orderId, string $time, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderOperateSkipMakeup(["orderId" => $orderId, "time" => $time, "operateId" => $operateId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}