<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-19 18:40:09
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderDiff
 */
class OrderDiff {
    private static string $serviceName = "Order";

    private static string $className = "OrderDiff";

    /**
     * 获取未支付的详情
     */
    public static function detail (int $orderDiffId, string $diffType, bool $showCancel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderDiffId" => $orderDiffId, "diffType" => $diffType, "showCancel" => $showCancel, ]);
    }
    /**
     * 取消未支付订单
     */
    public static function cancel (int $orderId, int $orderDiffId, string $reason, string $diffType, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reason" => $reason, "diffType" => $diffType, "inputStaffId" => $inputStaffId, ]);
    }
    /**
     * onTimeCloseNoPaidUpdateOrder
     */
    public static function onTimeCloseNoPaidUpdateOrder (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->onTimeCloseNoPaidUpdateOrder();
    }
    /**
     * 设置未支付的订单完成支付
     */
    public static function setPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false, float $paymentMoney = null, array $extend = [], string $people = '', string $account = '', string $reason = ''): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "fromPaymentGateway" => $fromPaymentGateway, "paymentMoney" => $paymentMoney, "extend" => $extend, "people" => $people, "account" => $account, "reason" => $reason, ]);
    }
    /**
     * 设置未支付的订单完成支付
     */
    public static function setZeroMoneyPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setZeroMoneyPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType, "operateId" => $operateId, ]);
    }
    /**
     * 通过子订单号批量查询diff订单-数据同步
     */
    public static function getOrdersBySubOrderNos (array $subOrderNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrdersBySubOrderNos(["subOrderNos" => $subOrderNos, ]);
    }
    /**
     * 获取未支付的详情
     */
    public static function getDiffType (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDiffType(["id" => $id, ]);
    }
    /**
     * 保存未支付的订单
     */
    public static function saveDepositOrder (int $orderId, int $orderDiffId, int $operateId = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveDepositOrder(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "operateId" => $operateId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}