<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-05 16:09:47
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RefundChange
 */
class RefundChange {
    private static string $serviceName = "Order";

    private static string $className = "RefundChange";

    /**
     * 创建转退
     *
     */
    public static function create (int $refundId, string $people, string $account, string $reason, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["refundId" => $refundId, "people" => $people, "account" => $account, "reason" => $reason, "inputStaffId" => $inputStaffId, ]);
    }
    /**
     * 删除转退
     *
     */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, ]);
    }
    /**
     * 转退列表
     *
     */
    public static function list (int $orderId, string $status, array $statusList, int $storeId, int $userId, array $storeIds, string $createdAtStart, string $createdAtEnd, string $passedAtStart, string $passedAtEnd, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderId" => $orderId, "status" => $status, "statusList" => $statusList, "storeId" => $storeId, "userId" => $userId, "storeIds" => $storeIds, "createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd, "passedAtStart" => $passedAtStart, "passedAtEnd" => $passedAtEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 转退详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 通过转退
     *
     */
    public static function pass (int $id, int $operateId, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, "operateId" => $operateId, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 拒绝转退
     *
     */
    public static function reject (int $id, int $operateId, string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "operateId" => $operateId, "reason" => $reason, ]);
    }
    /**
     * 批量获取转退列表
     *
     */
    public static function getListByRefundIds (array $refundIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByRefundIds(["refundIds" => $refundIds, ]);
    }
    /**
     * 修改转退账户信息
     *
     */
    public static function changeRefundAccount (int $id, string $people, string $account): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeRefundAccount(["id" => $id, "people" => $people, "account" => $account, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}