<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-17 10:49:54
 */
namespace Mainto\Bridge\Structs\Order\Order\Command;

class DiffPaymentLinkCommand {
    /**
     * @var  int
     * 订单id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  int
     * orderDiffId
     * validation: 
     */
    public int $orderDiffId;
    /**
     * @var  int
     * 操作伙伴id
     * validation: 
     */
    public int $operateId;
    /**
     * @var  bool
     * 是否强制更新
     * validation: 
     */
    public bool $forcedRefresh = false;
    /**
     * @var  null|string
     * 支付加密信息
     * validation: required_without_all:linkId,linkOrderId
     */
    public ?string $code = null;
    /**
     * @var  null|string
     * 支付信息（以LK- 开头）
     * validation: required_without_all:code,linkOrderId
     */
    public ?string $linkId = null;
    /**
     * @var  null|string
     * 支付订单id，创建支付链接时的orderId
     * validation: required_without_all:linkId,code
     */
    public ?string $linkOrderId = null;

    public function __construct (int $orderId = 0, int $orderDiffId = 0, int $operateId = 0) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($orderDiffId)) {
            $this->orderDiffId = $orderDiffId;
        }
        if (!is_null($operateId)) {
            $this->operateId = $operateId;
        }
    }

    public static function create(int $orderId = 0, int $orderDiffId = 0, int $operateId = 0): self {
        return new self($orderId, $orderDiffId, $operateId);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setOrderDiffId(int $orderDiffId): self {
        $this->orderDiffId = $orderDiffId;

        return $this;
    }

    public function setOperateId(int $operateId): self {
        $this->operateId = $operateId;

        return $this;
    }

    public function setForcedRefresh(bool $forcedRefresh): self {
        $this->forcedRefresh = $forcedRefresh;

        return $this;
    }

    public function setCode(?string $code): self {
        $this->code = $code;

        return $this;
    }

    public function setLinkId(?string $linkId): self {
        $this->linkId = $linkId;

        return $this;
    }

    public function setLinkOrderId(?string $linkOrderId): self {
        $this->linkOrderId = $linkOrderId;

        return $this;
    }
}