<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-04 14:15:15
 */
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Express
 */
class Express {
    private static string $serviceName = "Order";

    private static string $className = "Order\\Express";

    /**
     * 设置快递信息
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO
    */
    public static function setOrderExpress (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressCreateCommand $expressCreateCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->setOrderExpress($expressCreateCommand),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO"
        );
    }
    /**
     * 判断是否存在
     * @return  bool
    */
    public static function orderExistExpress (int $orderId, string $expressNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderExistExpress(["orderId" => $orderId, "expressNo" => $expressNo]);
    }
    /**
     * 清除快递信息
     * @return  bool
    */
    public static function cleanOrderExpress (int $orderId, string $expressNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanOrderExpress(["orderId" => $orderId, "expressNo" => $expressNo]);
    }
    /**
     * 更新订单快递信息
     * @return  bool
    */
    public static function updateOrderExpress (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressUpdateCommand $expressUpdateCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderExpress($expressUpdateCommand);
    }
    /**
     * 获取快递信息
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO
    */
    public static function expressInfo (int $orderId, string $expressNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->expressInfo(["orderId" => $orderId, "expressNo" => $expressNo]),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO"
        );
    }
    /**
     * 更新订单快递信息
     * @return  bool
    */
    public static function updateStatus (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressStatusCommand $expressStatusCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus($expressStatusCommand);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}