<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-30 10:29:10
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RefundGroupOrder
 */
class RefundGroupOrder {
    private static string $serviceName = "Order";

    private static string $className = "RefundGroupOrder";

    /**
     * 创建退款
     * @return  int
    */
    public static function create (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\CreateRefundGroupOrderCommand $createRefundGroupOrderCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createRefundGroupOrderCommand);
    }
    /**
     * 创建退款单并自动退款成功
     * @return  int
    */
    public static function createAndAutoRefundSuccess (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\CreateRefundGroupOrderCommand $createRefundGroupOrderCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndAutoRefundSuccess($createRefundGroupOrderCommand);
    }
    /**
     * 审核通过
     * @return  bool
    */
    public static function auditPass (int $refundGroupOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->auditPass(["refundGroupOrderId" => $refundGroupOrderId]);
    }
    /**
     * 审核拒绝
     * @return  bool
    */
    public static function auditReject (int $refundGroupOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->auditReject(["refundGroupOrderId" => $refundGroupOrderId]);
    }
    /**
     * 退款拒绝
     * @return  bool
    */
    public static function refundReject (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundRejectCommand $refundRejectCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundReject($refundRejectCommand);
    }
    /**
     * 退款同意
     * @return  bool
    */
    public static function refundSuccess (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundSuccessCommand $refundSuccessCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundSuccess($refundSuccessCommand);
    }
    /**
     * 团购订单退款列表
     * @return  \Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundListCommand $refundListCommand = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($refundListCommand),
            "\Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundListDTO"
        );
    }
    /**
     * 团购订单退款单详情
     * @return  \Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundDetailDTO
    */
    public static function detail (int $refundGroupOrderId, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["refundGroupOrderId" => $refundGroupOrderId, "withDeleted" => $withDeleted]),
            "\Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}