<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-13 12:03:18
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GroupOrder
 */
class GroupOrder {
    private static string $serviceName = "Order";

    private static string $className = "GroupOrder";

    /**
     * 团购订单列表
     * @return  array
    */
    public static function list (string $business_name, string $type, string $user_name, string $user_phone, array $order_ids, array $order_nos, array $status, int $store_id, int $is_private_pay, int $is_installment, string $installment_status, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["business_name" => $business_name, "type" => $type, "user_name" => $user_name, "user_phone" => $user_phone, "order_ids" => $order_ids, "order_nos" => $order_nos, "status" => $status, "store_id" => $store_id, "is_private_pay" => $is_private_pay, "is_installment" => $is_installment, "installment_status" => $installment_status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (string $businessName, string $userName, string $userPhone, string $email, array $detail, int $storeId, string $note, bool $isInstallment, bool $isPrivatePay, float $money, float $payMoney, string $type, float $discount, float $downPaymentMoney, float $balancePaymentMoney, float $outsideShotMoney, string $privateUserName, string $privateUserPhone, int $inputStaffId, array $extend, string $channel, array $packageDiscountIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["businessName" => $businessName, "userName" => $userName, "userPhone" => $userPhone, "email" => $email, "detail" => $detail, "storeId" => $storeId, "note" => $note, "isInstallment" => $isInstallment, "isPrivatePay" => $isPrivatePay, "money" => $money, "payMoney" => $payMoney, "type" => $type, "discount" => $discount, "downPaymentMoney" => $downPaymentMoney, "balancePaymentMoney" => $balancePaymentMoney, "outsideShotMoney" => $outsideShotMoney, "privateUserName" => $privateUserName, "privateUserPhone" => $privateUserPhone, "inputStaffId" => $inputStaffId, "extend" => $extend, "channel" => $channel, "packageDiscountIds" => $packageDiscountIds]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detailByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNo(["order_no" => $order_no]);
    }
    /**
     * 根据产品卡id获取团购订单详情
     * @return  mixed
    */
    public static function detailByProductCardId (int $card_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByProductCardId(["card_id" => $card_id]);
    }
    /**
     * 根据产品卡ids获取团购券码信息
     * @return  mixed
    */
    public static function getPreferentialByCardIds (array $card_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialByCardIds(["card_ids" => $card_ids]);
    }
    /**
     * 订单支付（全款与首款）
     * @return  mixed
    */
    public static function paid (int $id, string $pay_type, string $paid_at, float $money, string $payment_no = '', string $type = '', array $certificates = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paid(["id" => $id, "pay_type" => $pay_type, "paid_at" => $paid_at, "money" => $money, "payment_no" => $payment_no, "type" => $type, "certificates" => $certificates]);
    }
    /**
     * 取消订单
     * @return  mixed
    */
    public static function cancel (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id]);
    }
    /**
     * 订单审核
     * @return  mixed
    */
    public static function review (int $pay_id, string $action) {
        return RpcClass::getClass(self::$serviceName, self::$className)->review(["pay_id" => $pay_id, "action" => $action]);
    }
    /**
     * 支付尾款
     * @return  mixed
    */
    public static function balanceEntry (float $money, array $detail, int $order_id, string $pay_type, string $paid_at, bool $is_change, string $payment_no, array $certificates) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceEntry(["money" => $money, "detail" => $detail, "order_id" => $order_id, "pay_type" => $pay_type, "paid_at" => $paid_at, "is_change" => $is_change, "payment_no" => $payment_no, "certificates" => $certificates]);
    }
    /**
     * 获取关联拍摄订单
     * @return  mixed
    */
    public static function getPhotoOrders (int $group_order_id, array $order_ids, array $order_nos, string $user_name, string $user_phone, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoOrders(["group_order_id" => $group_order_id, "order_ids" => $order_ids, "order_nos" => $order_nos, "user_name" => $user_name, "user_phone" => $user_phone, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取所有团购关联订单id
     * @return  mixed
    */
    public static function getAllOrderIds (int $store_id = 0, bool $with_del = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOrderIds(["store_id" => $store_id, "with_del" => $with_del]);
    }
    /**
     * 获取预约产品
     * @return  mixed
    */
    public static function OrderProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->OrderProduct(["id" => $id]);
    }
    /**
     * 删除预约产品
     * @return  mixed
    */
    public static function deleteOrderProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrderProduct(["id" => $id]);
    }
    /**
     * 获取订单预约产品
     * @return  mixed
    */
    public static function getOrderProduct (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderProduct(["order_id" => $order_id]);
    }
    /**
     * 添加团购券码
     * @return  mixed
    */
    public static function addPreferential (array $card_ids, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPreferential(["card_ids" => $card_ids, "id" => $id]);
    }
    /**
     * 减少原始产品的剩余数量
     * @return  mixed
    */
    public static function decrementLeftNum (int $item_id, int $num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->decrementLeftNum(["item_id" => $item_id, "num" => $num]);
    }
    /**
     * 更新团购item的优惠模板id
     * @return  mixed
    */
    public static function updateTemplateId (int $item_id, int $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTemplateId(["item_id" => $item_id, "template_id" => $template_id]);
    }
    /**
     * 增加团购单开票信息
     * @return  mixed
    */
    public static function addInvoiceInfo (string $order_no, int $invoice_id, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addInvoiceInfo(["order_no" => $order_no, "invoice_id" => $invoice_id, "money" => $money]);
    }
    /**
     * 完成订单
     * @return  mixed
    */
    public static function finishPreferentialOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPreferentialOrder(["id" => $id]);
    }
    /**
     * 根据订单ID获取团购拍摄订单信息
     * @return  mixed
    */
    public static function getGroupOrderInfoByOrderId (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupOrderInfoByOrderId(["order_id" => $order_id]);
    }
    /**
     * 根据支付信息获取团购订单列表
     * @return  mixed
    */
    public static function getGroupOrderListByPay (string $pay_type, string $paid_at_start, string $paid_at_end, int $store_id, string $channel, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupOrderListByPay(["pay_type" => $pay_type, "paid_at_start" => $paid_at_start, "paid_at_end" => $paid_at_end, "store_id" => $store_id, "channel" => $channel, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 批量取消订单
     * @return  bool
    */
    public static function cancelOrders (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrders(["ids" => $ids]);
    }
    /**
     * 关闭未提取的团购订单
     * @return  mixed
    */
    public static function closeOrders (array $ids, string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrders(["ids" => $ids, "reason" => $reason]);
    }
    /**
     * 获取团购订单的余额
     * @return  float
    */
    public static function getExactGroupOrderBalance (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExactGroupOrderBalance(["id" => $id]);
    }
    /**
     * 修改团购订单的支付方式
     * @return  mixed
    */
    public static function changePayType (int $id, int $payId, string $payType, int $operateId, string $paymentNo = null, string $reason = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payId" => $payId, "payType" => $payType, "operateId" => $operateId, "paymentNo" => $paymentNo, "reason" => $reason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}