<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-13 14:41:20
 */
namespace Mainto\Bridge\Structs\Order\RefundGroupOrder\Command;

class CreateRefundGroupOrderCommand {
    /**
     * @var  int
     * 团购订单id
     * validation: 
     */
    public int $groupOrderId;
    /**
     * @var  string
     * 渠道
     * validation: in:store,business
     */
    public string $channel;
    /**
     * @var  float
     * 退款金额
     * validation: 
     */
    public float $refundMoney;
    /**
     * @var  int
     * 退款录入的员工id
     * validation: 
     */
    public int $inputStaffId;
    /**
     * @var  null|string
     * 退款账户
     * validation: 
     */
    public ?string $receiptAccount = null;
    /**
     * @var  null|string
     * 收款人
     * validation: 
     */
    public ?string $receiptPeople = null;
    /**
     * @var  null|string
     * 开户银行
     * validation: 
     */
    public ?string $openingBank = null;
    /**
     * @var  null|string
     * 退款原因
     * validation: 
     */
    public ?string $reason;
    /**
     * @var  \Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundGroupOrderItemCommand[]
     * 退款的团购商品信息
     * validation: 
     */
    public array $refundItems;

    public function __construct (int $groupOrderId = 0, string $channel = '', float $refundMoney = 0.0, int $inputStaffId = 0, ?string $reason = '', array $refundItems = []) {
        $this->groupOrderId = $groupOrderId;
        $this->channel = $channel;
        $this->refundMoney = $refundMoney;
        $this->inputStaffId = $inputStaffId;
        $this->reason = $reason;
        $this->refundItems = $refundItems;
    }

    public static function create(int $groupOrderId = 0, string $channel = '', float $refundMoney = 0.0, int $inputStaffId = 0, ?string $reason = '', array $refundItems = []): self {
        return new self($groupOrderId, $channel, $refundMoney, $inputStaffId, $reason, $refundItems);
    }

    public function setGroupOrderId(int $groupOrderId): self {
        $this->groupOrderId = $groupOrderId;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setRefundMoney(float $refundMoney): self {
        $this->refundMoney = $refundMoney;

        return $this;
    }

    public function setInputStaffId(int $inputStaffId): self {
        $this->inputStaffId = $inputStaffId;

        return $this;
    }

    public function setReceiptAccount(?string $receiptAccount): self {
        $this->receiptAccount = $receiptAccount;

        return $this;
    }

    public function setReceiptPeople(?string $receiptPeople): self {
        $this->receiptPeople = $receiptPeople;

        return $this;
    }

    public function setOpeningBank(?string $openingBank): self {
        $this->openingBank = $openingBank;

        return $this;
    }

    public function setReason(?string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setRefundItems(array $refundItems): self {
        $this->refundItems = $refundItems;

        return $this;
    }
}