<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-13 14:41:20
 */
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AfterSaleOrder
 */
class AfterSaleOrder {
    private static string $serviceName = "Order";

    private static string $className = "AfterSaleOrder\\AfterSaleOrder";

    /**
     * 获取补偿申请原因
     * @return  array
    */
    public static function getReasons (string $type = 'preferential', bool $withDel = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReasons(["type" => $type, "withDel" => $withDel]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ReasonTreeDTO[]"
        );
    }
    /**
     * 获取用户售后统计数据
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO
    */
    public static function getUserStatistics (int $userId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserStatistics(["userId" => $userId, "type" => $type]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO"
        );
    }
    /**
     * 获取门店售后统计数据
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO
    */
    public static function getStoreStatistics (int $storeId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreStatistics(["storeId" => $storeId, "type" => $type]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO"
        );
    }
    /**
     * 获取订单售后统计数据
     * @return  int
    */
    public static function getOrderStatistics (int $orderId, string $type = 'preferential') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStatistics(["orderId" => $orderId, "type" => $type]);
    }
    /**
     * 提交售后申请单
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function create (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $createCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($createCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 更新售后单状态
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function update (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $updateCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update($updateCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 获取售后单详情
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 售后评价
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO
    */
    public static function createEvaluation (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $createEvalutionCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createEvaluation($createEvalutionCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO"
        );
    }
    /**
     * 售后单列表
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $listCommand = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO"
        );
    }
    /**
     * 判断是否已存在售后单
     * @return  bool
    */
    public static function isAlreadyCreateAfterSale (int $orderId, string $type = 'preferential') {
        return RpcClass::getClass(self::$serviceName, self::$className)->isAlreadyCreateAfterSale(["orderId" => $orderId, "type" => $type]);
    }
    /**
     * 使用海马体订单查询存在的售后单
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function getAfterSaleByOrderId (int $orderId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByOrderId(["orderId" => $orderId, "type" => $type]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 通过审批实例id获取售后单信息
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
    */
    public static function getAfterSaleByProcessInstanceId (string $processInstanceId, string $status = null, string $type = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleByProcessInstanceId(["processInstanceId" => $processInstanceId, "status" => $status, "type" => $type]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }
    /**
     * 使用海马体订单查询已申请的售后单汇总信息
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO
    */
    public static function getAfterSaleSumInfo (int $orderId, string $type = 'preferential', array $statusArr = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleSumInfo(["orderId" => $orderId, "type" => $type, "statusArr" => $statusArr]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO"
        );
    }
    /**
     * 根据订单ids查询售后单
     * @return  array
    */
    public static function all (?\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $allCommand = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all($allCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO[]"
        );
    }
    /**
     * 处理售后单结果
     * @return  bool
    */
    public static function dealResult (int $id, string $status, string $voucherNumber = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->dealResult(["id" => $id, "status" => $status, "voucherNumber" => $voucherNumber]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}