<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-15 16:09:43
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderRetake
 */
class OrderRetake {
    private static string $serviceName = "Order";

    private static string $className = "OrderRetake";

    /**
     * 创建重拍订单
     */
    public static function create (int $orderId, int $storeId, int $peopleNum, float $money, float $realMoney, array $productInfo, array $retakeSkuIds, array $retakeUpgradeIds, string $reserveTime, int $occupyNum, array $occupyIndexs, string $reason, array $reasonIds, string $note, int $inputStaffId, array $extend, bool $afterLookPhotoCompleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "storeId" => $storeId, "peopleNum" => $peopleNum, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "retakeSkuIds" => $retakeSkuIds, "retakeUpgradeIds" => $retakeUpgradeIds, "reserveTime" => $reserveTime, "occupyNum" => $occupyNum, "occupyIndexs" => $occupyIndexs, "reason" => $reason, "reasonIds" => $reasonIds, "note" => $note, "inputStaffId" => $inputStaffId, "extend" => $extend, "afterLookPhotoCompleted" => $afterLookPhotoCompleted, ]);
    }
    /**
     * 获取重拍的基础信息
     */
    public static function getBaseRetakeInfo (int $orderId, int $retakeOrderId, string $status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfo(["orderId" => $orderId, "retakeOrderId" => $retakeOrderId, "status" => $status, ]);
    }
    /**
     * 根据原订单ids，批量获取重拍的基础信息
     */
    public static function getBaseRetakeInfoListByOrderIds (array $orderIds, string $status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfoListByOrderIds(["orderIds" => $orderIds, "status" => $status, ]);
    }
    /**
     * 根据重拍的订单ids，批量获取重拍的基础信息
     */
    public static function getBaseRetakeInfoListByRetakeOrderIds (array $retakeOrderIds, string $status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseRetakeInfoListByRetakeOrderIds(["retakeOrderIds" => $retakeOrderIds, "status" => $status, ]);
    }
    /**
     * 取消重拍订单
     */
    public static function cancel (int $id, int $inputStaffId, string $reason = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["id" => $id, "inputStaffId" => $inputStaffId, "reason" => $reason, ]);
    }
    /**
     * 退款原因选项
     */
    public static function reasonOptions (string $category = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonOptions(["category" => $category, ]);
    }
    /**
     * 退款原因详情
     */
    public static function reasonDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reasonDetail(["id" => $id, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}