<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-25 20:56:37
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OfflineOrder
 */
class OfflineOrder {
    private static string $serviceName = "Order";

    private static string $className = "OfflineOrder";

    /**
     * 订单列表
     * @return  mixed
    */
    public static function list (string $pay_type, string $order_no, string $status, array $status_list, int $store_id, array $store_id_list, int $item_id, string $paid_at_start, string $paid_at_end, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["pay_type" => $pay_type, "order_no" => $order_no, "status" => $status, "status_list" => $status_list, "store_id" => $store_id, "store_id_list" => $store_id_list, "item_id" => $item_id, "paid_at_start" => $paid_at_start, "paid_at_end" => $paid_at_end, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 订单详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 订单详情【根据订单号获取】
     * @return  mixed
    */
    public static function detailByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByNo(["order_no" => $order_no]);
    }
    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (int $storeId, float $money, int $incomeItemId, array $childItemNums, int $amount, string $note, array $couponIds, string $reserveTime, string $serviceTime, array $printNums) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["storeId" => $storeId, "money" => $money, "incomeItemId" => $incomeItemId, "childItemNums" => $childItemNums, "amount" => $amount, "note" => $note, "couponIds" => $couponIds, "reserveTime" => $reserveTime, "serviceTime" => $serviceTime, "printNums" => $printNums]);
    }
    /**
     * 根据订单号获取订单ID
     * @return  mixed
    */
    public static function getIdByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["order_no" => $order_no]);
    }
    /**
     * 移除订单
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }
    /**
     * 设置订单完成支付
     * @return  mixed
    */
    public static function setPaid (int $id, string $payType, string $paymentNo = '', float $payMoney = null, string $dianpingCouponCode = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo, "payMoney" => $payMoney, "dianpingCouponCode" => $dianpingCouponCode]);
    }
    /**
     * 全部收入项目
     * @return  mixed
    */
    public static function allIncomeItems (bool $withHidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allIncomeItems(["withHidden" => $withHidden]);
    }
    /**
     * 批量更新订单的发票ID
     * @return  mixed
    */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateInvoiceId(["invoice_id" => $invoice_id, "order_nos" => $order_nos]);
    }
    /**
     * 修改支付方式
     * @return  mixed
    */
    public static function changePayType (int $id, string $pay_type, string $payment_no, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type, "payment_no" => $payment_no, "extend" => $extend]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}