<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-30 10:07:52
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Nps
 */
class Nps {
    private static string $serviceName = "Order";

    private static string $className = "Nps";

    /**
     * NPS列表
     */
    public static function list (int $storeId, array $orderIds, int $score, string $startTime, string $endTime, int $page, int $pageSize, bool $isSn, bool $isNeedStat) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["storeId" => $storeId, "orderIds" => $orderIds, "score" => $score, "startTime" => $startTime, "endTime" => $endTime, "page" => $page, "pageSize" => $pageSize, "isSn" => $isSn, "isNeedStat" => $isNeedStat, ]);
    }
    /**
     * 查询伙伴的NPS列表
     */
    public static function getStaffNpsList (int $staffId, int $storeId, array $orderIds, string $job, int $score, string $startTime, string $endTime, int $page, int $pageSize, bool $isSn, bool $isNeedStat) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffNpsList(["staffId" => $staffId, "storeId" => $storeId, "orderIds" => $orderIds, "job" => $job, "score" => $score, "startTime" => $startTime, "endTime" => $endTime, "page" => $page, "pageSize" => $pageSize, "isSn" => $isSn, "isNeedStat" => $isNeedStat, ]);
    }
    /**
     * 创建NPS
     */
    public static function create (int $orderId, int $userId, int $all, int $receptionist, int $cameraman, int $dresser, int $retoucher, string $note, int $isSn = 2, int $isShare = 2, int $isStat = 2, array $extend, int $retoucherCommunication, int $retoucherResponse, int $photoSatisfaction) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "userId" => $userId, "all" => $all, "receptionist" => $receptionist, "cameraman" => $cameraman, "dresser" => $dresser, "retoucher" => $retoucher, "note" => $note, "isSn" => $isSn, "isShare" => $isShare, "isStat" => $isStat, "extend" => $extend, "retoucherCommunication" => $retoucherCommunication, "retoucherResponse" => $retoucherResponse, "photoSatisfaction" => $photoSatisfaction, ]);
    }
    /**
     * 创建NPS(V2)
     */
    public static function createV2 (int $orderId, int $userId, array $staffs, string $note, int $isSn = 2, int $isShare = 2, int $isStat = 2, array $extend, int $retoucherCommunication, int $retoucherResponse, float $photoSatisfaction) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createV2(["orderId" => $orderId, "userId" => $userId, "staffs" => $staffs, "note" => $note, "isSn" => $isSn, "isShare" => $isShare, "isStat" => $isStat, "extend" => $extend, "retoucherCommunication" => $retoucherCommunication, "retoucherResponse" => $retoucherResponse, "photoSatisfaction" => $photoSatisfaction, ]);
    }
    /**
     * 更新NPS
     */
    public static function update (int $id, int $all = 0, int $receptionist = 0, int $cameraman = 0, int $dresser = 0, int $retoucher = 0, int $isStat = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "all" => $all, "receptionist" => $receptionist, "cameraman" => $cameraman, "dresser" => $dresser, "retoucher" => $retoucher, "isStat" => $isStat, ]);
    }
    /**
     * 更加订单ID获取NPS信息
     */
    public static function getByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByOrderId(["orderId" => $orderId, ]);
    }
    /**
     * 获取未评价NPS的订单
     */
    public static function getNoneNpsOrders (int $storeId, string $startTime, string $endTime, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoneNpsOrders(["storeId" => $storeId, "startTime" => $startTime, "endTime" => $endTime, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 批量检测订单是否有nps
     */
    public static function batchCheckOrderHasNps (array $order_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCheckOrderHasNps(["order_ids" => $order_ids, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}