<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-26 09:29:00
 */
namespace Mainto\Bridge\Structs\Order\MessageHook\Command;

class SaleSkuCommand {
    /**
     * @var  int
     * 产品id
     * validation: 
     */
    public int $productId;
    /**
     * @var  int
     * orderSale的Id，区别相同产品id
     * validation: 
     */
    public int $orderSaleId = 1;
    /**
     * @var  int
     * 产品数量
     * validation: 
     */
    public int $productNum = 1;
    /**
     * @var  int
     * 是否主产品
     * validation: 
     */
    public int $isPrimary = 0;
    /**
     * @var  string
     * 销售类型 : 一销 二销
     * validation: in:order,ds
     */
    public string $saleType;
    /**
     * @var  string
     * 计数类型（ add decrease
     * validation: in:add,decrease
     */
    public string $counterType;
    /**
     * @var  int
     * 产品拍摄人数
     * validation: 
     */
    public int $peopleNum = 1;

    public function __construct (int $productId = 0, string $saleType = '', string $counterType = '') {
        $this->productId = $productId;
        $this->saleType = $saleType;
        $this->counterType = $counterType;
    }

    public static function create(int $productId = 0, string $saleType = '', string $counterType = ''): self {
        return new self($productId, $saleType, $counterType);
    }

    public function setProductId(int $productId): self {
        $this->productId = $productId;

        return $this;
    }

    public function setOrderSaleId(int $orderSaleId): self {
        $this->orderSaleId = $orderSaleId;

        return $this;
    }

    public function setProductNum(int $productNum): self {
        $this->productNum = $productNum;

        return $this;
    }

    public function setIsPrimary(int $isPrimary): self {
        $this->isPrimary = $isPrimary;

        return $this;
    }

    public function setSaleType(string $saleType): self {
        $this->saleType = $saleType;

        return $this;
    }

    public function setCounterType(string $counterType): self {
        $this->counterType = $counterType;

        return $this;
    }

    public function setPeopleNum(int $peopleNum): self {
        $this->peopleNum = $peopleNum;

        return $this;
    }
}