<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-26 09:29:00
 */
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderUpgrade
 */
class OrderUpgrade {
    private static string $serviceName = "Order";

    private static string $className = "OrderUpgrade";

    /**
     * 获取订单中的拍摄主产品
     * @return  array
    */
    public static function getOrderSales (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderSales(["id" => $id]);
    }
    /**
     * 完成订单之后添加升级服务产品
     * @return  array
    */
    public static function createUpgradeSku (int $id, float $money, float $realMoney, array $productInfo, array $couponInfo, int $productCardId, float $productCardDeductionMoney, float $specialDiscountMoney, string $discountType, int $inputStaffId, int $specialDiscountStaffId, string $discountNote) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUpgradeSku(["id" => $id, "money" => $money, "realMoney" => $realMoney, "productInfo" => $productInfo, "couponInfo" => $couponInfo, "productCardId" => $productCardId, "productCardDeductionMoney" => $productCardDeductionMoney, "specialDiscountMoney" => $specialDiscountMoney, "discountType" => $discountType, "inputStaffId" => $inputStaffId, "specialDiscountStaffId" => $specialDiscountStaffId, "discountNote" => $discountNote]);
    }
    /**
     * 服务完成
     * @return  bool
    */
    public static function serviceComplete (int $id = null, array $ids = null, bool $isUserComplete = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete(["id" => $id, "ids" => $ids, "isUserComplete" => $isUserComplete]);
    }
    /**
     * 设置看片完成
     * @return  bool
    */
    public static function setLookPhotoComplete (int $id = null, array $ids = null, string $type = 'user') {
        return RpcClass::getClass(self::$serviceName, self::$className)->setLookPhotoComplete(["id" => $id, "ids" => $ids, "type" => $type]);
    }
    /**
     * 看片完成标记清除
     * @return  mixed
    */
    public static function clearLookPhotoCompletedAt (int $id = null, array $ids = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearLookPhotoCompletedAt(["id" => $id, "ids" => $ids]);
    }
    /**
     * 获取订单升级服务的产品列表
     * @return  mixed
    */
    public static function getUpgradeSkuList (int $storeId, int $orderId, array $storeIds, array $orderIds, string $createTimeStart, string $createTimeEnd, string $status, array $statusList, bool $hasServiceCompleteAt = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpgradeSkuList(["storeId" => $storeId, "orderId" => $orderId, "storeIds" => $storeIds, "orderIds" => $orderIds, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "status" => $status, "statusList" => $statusList, "hasServiceCompleteAt" => $hasServiceCompleteAt]);
    }
    /**
     * 设置照片交付时间
     * @return  array
    */
    public static function setPhotoFinishedAt (array $skuIds, string $photoFinishedAt = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPhotoFinishedAt(["skuIds" => $skuIds, "photoFinishedAt" => $photoFinishedAt]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}