<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reasonOptionsByParams(array $params)
 * @method reasonDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method surplusRefundListByParams(array $params)
 * @method detailByParams(array $params)
 * @method getAllRefundListByOrderIdByParams(array $params)
 * @method passByParams(array $params)
 * @method passChangeRefundByParams(array $params)
 * @method modifyInfoByParams(array $params)
 * @method removeByParams(array $params)
 * @method rejectByParams(array $params)
 * @method reapplyByParams(array $params)
 * @method fixRefundResultByParams(array $params)
 * @method getOrderRefundInfoByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款原因选项
     *
     * @param  string $category 分类：category_user_refund,category_admin_refund [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reasonOptions (string $category = '') {
        return self::getClass()->reasonOptions([
            "category" => $category,
        ]);
    }

    /**
     * 退款原因详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reasonDetail (int $id) {
        return self::getClass()->reasonDetail([
            "id" => $id,
        ]);
    }

    /**
     * 除了page 和pageSize之外，至少需要一个其他参数。由于参数变量太多，没有用required_without_all 来显示，在代码中进行判断
     *
     * @support  int $orderId 主订单ID [ require false ]
     * @support  array $orderIds 主订单IDs [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态array [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $storeIds 门店IDs [ require false ]
     * @support  string $orderPayType 订单支付方式 [ require false ]
     * @support  string $applyTimeStart 申请时间-开始 [ require false ]
     * @support  string $applyTimeEnd 申请时间-结束 [ require false ]
     * @support  string $processTimeStart 处理时间-开始 [ require false ]
     * @support  string $processTimeEnd 处理时间-结束 [ require false ]
     * @support  string $completeTimeStart 退款完成-开始 [ require false ]
     * @support  string $completeTimeEnd 退款完成-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $pageSize  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 手续费剩余退款列表
     *
     * @support  int $orderId 主订单ID [ require false ]
     * @support  array $orderIds 主订单IDs [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态array [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $storeIds 门店IDs [ require false ]
     * @support  string $applyTimeStart 申请时间-开始 [ require false ]
     * @support  string $applyTimeEnd 申请时间-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $pageSize  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function surplusRefundList () {
        return self::getClass()->surplusRefundList([
        ]);
    }

    /**
     * 退款详情
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单转退列表调用该接口
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $orderType 退款类型：order 订单 upgrade 升级服务 [ require false ]
     * @param  string $type 转退类型，查询转退：change_product [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRefundListByOrderId (int $orderId, string $orderType = null, string $type = 'all_refund') {
        return self::getClass()->getAllRefundListByOrderId([
            "orderId" => $orderId,
            "orderType" => $orderType,
            "type" => $type,
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function passChangeRefund (int $id) {
        return self::getClass()->passChangeRefund([
            "id" => $id,
        ]);
    }

    /**
     * 修改信息
     *
     * @param  int $id 退款ID [ require true ]
     * @param  int $operateId 操作伙伴 [ require true ]
     * @param  string $people 退款人 [ require false ]
     * @param  string $account 退款账户 [ require false ]
     * @param  array $extend 预约退款extend扩展信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyInfo (int $id, int $operateId, string $people = null, string $account = null, array $extend = null) {
        return self::getClass()->modifyInfo([
            "id" => $id,
            "operateId" => $operateId,
            "people" => $people,
            "account" => $account,
            "extend" => $extend,
        ]);
    }

    /**
     * 删除退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 退款原因 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, string $reason = '') {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 重新申请退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @param  int $inputStaffId 录入人伙伴ID [ require true ]
     * @param  int $scale 比例 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function reapply (int $id, string $people, string $account, string $reason, int $inputStaffId, int $scale = 100) {
        return self::getClass()->reapply([
            "id" => $id,
            "people" => $people,
            "account" => $account,
            "reason" => $reason,
            "inputStaffId" => $inputStaffId,
            "scale" => $scale,
        ]);
    }

    /**
     * 已废弃，4.2.10将删除
     *
     * @param  int $id 退款ID [ require true ]
     * @param  float $autoRealMoney 自动退款金额 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fixRefundResult (int $id, float $autoRealMoney) {
        return self::getClass()->fixRefundResult([
            "id" => $id,
            "autoRealMoney" => $autoRealMoney,
        ]);
    }

    /**
     * 获取订单的退款相关信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderRefundInfo (int $orderId) {
        return self::getClass()->getOrderRefundInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}