<?php
namespace Mainto\Bridge\Enums\Order\Refund;

class RefundStatusEnum {
    /**
     * 等待退款
     */
    const PENDING = 'pending';
    /**
     * 退款成功
     */
    const SUCCESS = 'success';
    /**
     * 等待通知确认
     */
    const WAIT_CONFIRMATION = 'wait_confirmation';
    /**
     * 等待修复确认
     */
    const CONFIRMING = 'confirming';
    /**
     * 拒绝退款
     */
    const REJECTED = 'rejected';
    /**
     * 已经退款的状态
     */
    const REFUNDED_STATUS_MAP = [0 => 'success',1 => 'wait_confirmation',2 => 'confirming'];
    const UN_REJECTED_STATUS_MAP = [0 => 'success',1 => 'wait_confirmation',2 => 'confirming',3 => 'pending'];
}