<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createIgnoreOccupyNumByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailV2ByParams(array $params)
 * @method cancelByParams(array $params)
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method getStoreWaitSignNumByParams(array $params)
 * @method removeByParams(array $params)
 * @method deleteByUserByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeMeiTuanOrderByParams(array $params)
 * @method closeMantuOrderByParams(array $params)
 * @method useGiftCardMoneyByParams(array $params)
 * @method giftCardPrePayByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method setZeroMoneyPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method finishPaperlessByParams(array $params)
 * @method finishByParams(array $params)
 * @method setOrderWorkloadsByParams(array $params)
 * @method getPaperlessWorkloadsByParams(array $params)
 * @method getPaperlessWorkloadsListByParams(array $params)
 * @method completeLookPhotoByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method clearConfirmationByParams(array $params)
 * @method getConfirmationByIdsByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method getOrderStatusByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method getOrderConsumeMoneyByParams(array $params)
 * @method getOrderOperateLogByParams(array $params)
 * @method batchGetOrdersOperateLogByParams(array $params)
 * @method getOrderOperateLogCountByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method queryDsListWithStoreByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method changeExtendByParams(array $params)
 * @method userReachedByParams(array $params)
 * @method getUserReachedDetailByParams(array $params)
 * @method modifyUserReachedByParams(array $params)
 * @method cancelUserReachedByParams(array $params)
 * @method setUserReachedPaidByParams(array $params)
 * @method getStoreFinishOrderCountByParams(array $params)
 * @method setOrderPaperlessFinishByParams(array $params)
 * @method getInvoiceListByParams(array $params)
 * @method getInvoiceAllByParams(array $params)
 * @method getStoreOrderCountByParams(array $params)
 * @method getOrderUnSetServiceCompleteByParams(array $params)
 * @method searchOrderNoByParams(array $params)
 * @method getOrderLookPhotoReserveLitByParams(array $params)
 * @method getOrderNosByIdsByParams(array $params)
 * @method getOrderSaleSkuAndUpgradeSkuByParams(array $params)
 * @method isBindUserByParams(array $params)
 * @method getProductOrdersByParams(array $params)
 * @method getProductOrderListByParams(array $params)
 * @method searchOrdersWithAllSkusByParams(array $params)
 * @method searchOrdersWithAllSkusUseDbByParams(array $params)
 * @method retailOrderHookChangeStoreByParams(array $params)
 * @method searchOrderWithSkuByParams(array $params)
 * @method getUserInvoiceStoreListByParams(array $params)
 * @method getOrderStoreIdsByUserIdByParams(array $params)
 * @method getAlreadyInvoiceOrderByUserIdByParams(array $params)
 * @method searchOrderBasicByParams(array $params)
 * @method setStudentMembershipByParams(array $params)
 * @method cleanStudentMembershipByParams(array $params)
 * @method orderBasicDetailByParams(array $params)
 * @method createOrderBalancePaymentByParams(array $params)
 * @method groupOrderPaidByParams(array $params)
 * @method orderPeoplesByParams(array $params)
 * @method setPhotoFinishedAtByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 可以添加两个相同的产品（升级服务或者加修加印不一定是一样的）,以addNumber区分
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @support  int $orderUserId 订单用户ID [ require true ]
     * @support  string $userName 用户名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $from 订单来源 [ require false ]
     * @support  string $channel 订单渠道 [ require true ]
     * @support  int $peopleNum 订单到店人数（商品的最大人数） [ require false ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [ require true ]
     * @support  array $productInfo 订单详情 [ require false ]
     * @support  array $reachedInfo 到店签到信息（门店端使用） [ require false ]
     * @support  array $globalDiscountIds 优惠活动IDs [ require false ]
     * @support  float $globalDiscountMoney 优惠活动金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠信息 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  float $businessDiscountMoney business优惠金额 [ require false ]
     * @support  string $interiorCouponCode 开单折扣码UUID [ require false ]
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [ require false ]
     * @support  array $couponInfo 优惠券信息 [ require false ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [ require false ]
     * @support  float $specialDiscountMoney 特殊折扣金额 [ require false ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id [ require false ]
     * @support  string $discountNote 特殊折扣备注 [ require false ]
     * @support  string $discountType 特殊折扣类型 [ require false ]
     * @support  float $peopleDiscountMoney 人数优惠（加购优惠） [ require false ]
     * @support  float $giftCardPayMoney 礼品卡金额 [ require false ]
     * @support  float $marketCardMoney 商场卡金额 [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @support  int $occupyNum 排单表占点数量(如果setReservation为true，必须要occupyNum或者occupyIndexs) [ require false ]
     * @support  array $occupyIndexs 排单表占点位置 [ require false ]
     * @support  string $module 订单模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require false ]
     * @support  array $extend 订单extend [ require false ]
     * @support  string $paymentMethod 支付类型 [ require false ]
     * @support  float $depositMoney 定金金额 [ require false ]
     * @support  float $balanceMoney 尾款金额 [ require false ]
     * @support  bool $setReservation 是否需要订单设置排单表信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 创建订单——忽略占点信息
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @support  int $orderUserId 订单用户ID [ require true ]
     * @support  string $userName 用户名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  string $userEmail 用户邮箱 [ require false ]
     * @support  string $from 订单来源 [ require false ]
     * @support  string $channel 订单渠道 [ require true ]
     * @support  int $peopleNum 订单到店人数（商品的最大人数） [ require false ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [ require true ]
     * @support  array $productInfo 订单详情 [ require false ]
     * @support  array $reachedInfo 到店签到信息（门店端使用） [ require false ]
     * @support  array $globalDiscountIds 优惠活动IDs [ require false ]
     * @support  float $globalDiscountMoney 优惠活动金额 [ require false ]
     * @support  array $packageDiscountIds 套餐优惠信息 [ require false ]
     * @support  float $packageDiscountMoney 套餐优惠金额 [ require false ]
     * @support  float $businessDiscountMoney business优惠金额 [ require false ]
     * @support  string $interiorCouponCode 开单折扣码UUID [ require false ]
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [ require false ]
     * @support  array $couponInfo 优惠券信息 [ require false ]
     * @support  int $productCardId 产品卡ID [ require false ]
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [ require false ]
     * @support  float $specialDiscountMoney 特殊折扣金额 [ require false ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id [ require false ]
     * @support  string $discountNote 特殊折扣备注 [ require false ]
     * @support  string $discountType 特殊折扣类型 [ require false ]
     * @support  float $peopleDiscountMoney 人数优惠（加购优惠） [ require false ]
     * @support  float $giftCardPayMoney 礼品卡金额 [ require false ]
     * @support  float $marketCardMoney 商场卡金额 [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @support  int $occupyNum 排单表占点数量 [ require false ]
     * @support  array $occupyIndexs 排单表占点位置 [ require false ]
     * @support  string $module 订单模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require false ]
     * @support  array $extend 订单extend [ require false ]
     * @support  string $paymentMethod 支付类型 [ require false ]
     * @support  float $depositMoney 定金金额 [ require false ]
     * @support  float $balanceMoney 尾款金额 [ require false ]
     * @support  bool $setReservation 是否需要订单设置排单表信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function createIgnoreOccupyNum () {
        return self::getClass()->createIgnoreOccupyNum([
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require false ]
     * @param  string $orderNo 订单编号 [ require false ]
     * @param  bool $withDelete 是否包含删除的订单 [ require false ]
     * @param  bool $withModifyRefund 是否包含已经关闭的订单 [ require false ]
     * @param  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false) {
        return self::getClass()->detail([
            "id" => $id,
            "orderNo" => $orderNo,
            "withDelete" => $withDelete,
            "withRefund" => $withRefund,
            "withModifyRefund" => $withModifyRefund,
        ]);
    }

    /**
     * 订单详情V2
     *
     * @param  int $id 订单ID [ require false ]
     * @param  string $orderNo 订单编号 [ require false ]
     * @param  bool $withDelete 是否包含删除的订单 [ require false ]
     * @param  bool $withModifyRefund 是否包含已经关闭的订单 [ require false ]
     * @param  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @param  bool $withTurnover 是都需要流水信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailV2 (int $id = null, string $orderNo = null, bool $withDelete = false, bool $withRefund = true, bool $withModifyRefund = false, bool $withTurnover = false) {
        return self::getClass()->detailV2([
            "id" => $id,
            "orderNo" => $orderNo,
            "withDelete" => $withDelete,
            "withRefund" => $withRefund,
            "withModifyRefund" => $withModifyRefund,
            "withTurnover" => $withTurnover,
        ]);
    }

    /**
     * 一个订单不可以同时调用不同的可以修改订单状态的操作
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 使用数据库查询订单
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $notInOrderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb([
        ]);
    }

    /**
     * 使用ES查询订单
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $origin 订单来源:mobile,pc [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  array $neqStatusList 不包含的订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $lastUserPhone 手机号(只查后四位) [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs([
        ]);
    }

    /**
     * 获取门店等待签到的数据
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreWaitSignNum (int $storeId, string $reserveTime = null) {
        return self::getClass()->getStoreWaitSignNum([
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 操作删除的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteByUser (int $id, int $operateId) {
        return self::getClass()->deleteByUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  string $note 关闭备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason, int $operateId, string $note = '') {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
            "note" => $note,
        ]);
    }

    /**
     * 关闭美团订单
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMeiTuanOrder (int $id) {
        return self::getClass()->closeMeiTuanOrder([
            "id" => $id,
        ]);
    }

    /**
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require false ]
     * @param  int $operateId 录单人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMantuOrder (int $id, string $reason = '', int $operateId = 0) {
        return self::getClass()->closeMantuOrder([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 已提交的子订单在正式支付前，使用礼品卡金额抵扣一部分实付金额
     * 调用该接口会重新设置子订单的实付金额和礼品卡支付金额
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardPayMoney 礼品卡金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return self::getClass()->useGiftCardMoney([
            "id" => $id,
            "giftCardPayMoney" => $giftCardPayMoney,
        ]);
    }

    /**
     * 本接口对已经提交了，但是处于待支付状态的订单，进行礼品卡预支付
     * 本接口适应场景：当管理端开单，订单已经提交，即将进行下一步支付的时候，可以修改支付金额，选择全部或者部分金额使用礼品卡支付。
     * 签到不可以使用礼品卡
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giftCardPrePay (int $id) {
        return self::getClass()->giftCardPrePay([
            "id" => $id,
        ]);
    }

    /**
     * 签到不可以使用礼品卡
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $marketCardMoney 商场卡金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return self::getClass()->useMarketCardMoney([
            "id" => $id,
            "marketCardMoney" => $marketCardMoney,
        ]);
    }

    /**
     * 设置订单完成支付——新建订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @param  int $operateId 录单人 [ require false ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require false ]
     * @param  float $paymentMoney 支付金额(缦图订单必填) [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false, float $paymentMoney = null) {
        return self::getClass()->setPaid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
            "paymentMoney" => $paymentMoney,
        ]);
    }

    /**
     * 设置零元支付订单完成支付——新建订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型:gift_card,market_card,coupon,product_card,interior_coupon_code [ require true ]
     * @param  int $operateId 录单人 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function setZeroMoneyPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0) {
        return self::getClass()->setZeroMoneyPaid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function start (int $id, int $operateId) {
        return self::getClass()->start([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 摄影师将订单中的拍摄产品全部操作上传看片
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPaperless (int $id) {
        return self::getClass()->finishPaperless([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单和录入工作量拆分开,如果是缦图订单，需要另外设置完成看片类型及时间（原finishMantuOrder已废弃）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish (int $id, int $operateId) {
        return self::getClass()->finish([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 门店录入工作量
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 store_id 门店id [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setOrderWorkloads (int $id, array $workloads, int $operateId) {
        return self::getClass()->setOrderWorkloads([
            "id" => $id,
            "workloads" => $workloads,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取工作量
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $staffTypes 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaperlessWorkloads (int $id, array $staffTypes = [0 => 'sys',1 => 'hzs',2 => 'qt',3 => 'child_teaser']) {
        return self::getClass()->getPaperlessWorkloads([
            "id" => $id,
            "staffTypes" => $staffTypes,
        ]);
    }

    /**
     * 批量获取工作量
     *
     * @param  array $ids 订单Ids [ require true ]
     * @param  array $staffTypes 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaperlessWorkloadsList (array $ids, array $staffTypes = [0 => 'sys',1 => 'hzs',2 => 'qt',3 => 'child_teaser']) {
        return self::getClass()->getPaperlessWorkloadsList([
            "ids" => $ids,
            "staffTypes" => $staffTypes,
        ]);
    }

    /**
     * （同时需要录入工作量,自动完成看片也调用该接口）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $staffId 伙伴ID [ require false ]
     * @param  int $workPer 工作量占比 [ require false ]
     * @param  int $storeId 门店id [ require false ]
     * @param  string $type 完成看片类型:auto,user [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completeLookPhoto (int $id, int $staffId = 0, int $workPer = 0, string $type = 'user', int $storeId = 0) {
        return self::getClass()->completeLookPhoto([
            "id" => $id,
            "staffId" => $staffId,
            "workPer" => $workPer,
            "type" => $type,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 服务整体完成（用户确认服务完成）
     *
     * @param  int $id id [ require true ]
     * @param  string $type 完成类型:auto,user [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function serviceComplete (int $id, string $type) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  string $note 备注（如果填则记录） [ require false ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  int $occupyNum 排单表占点数量 [ require false ]
     * @param  array $occupyIndexs 排单表占点位置 [ require true ]
     * @param  string $from 来源(&#039;pc&#039;,&#039;mobile&#039;) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId, string $note = '', int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = []) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
            "note" => $note,
            "occupyNum" => $occupyNum,
            "from" => $from,
            "occupyIndexs" => $occupyIndexs,
        ]);
    }

    /**
     * 只清除自动看片的标识，可以再次看片
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearConfirmation (int $id) {
        return self::getClass()->clearConfirmation([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单id查询自动看片完成信息
     *
     * @param  array $ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getConfirmationByIds (array $ids) {
        return self::getClass()->getConfirmationByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 改变订单的看片预约时间
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $lookPhotoReserveTime 看片预约时间 [ require false ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeLookPhotoReserveTime (int $id, int $operateId, string $lookPhotoReserveTime = null) {
        return self::getClass()->changeLookPhotoReserveTime([
            "id" => $id,
            "operateId" => $operateId,
            "lookPhotoReserveTime" => $lookPhotoReserveTime,
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id, int $operateId) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 把完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverFinishedToWaitShooting (int $id, int $operateId) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取门店下订单不同状态数量【专供缦图订单接口】
     *
     * @param  int $storeId 门店iD [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  bool $needToday 是否仅需要当天数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return self::getClass()->getOrderStatus([
            "storeId" => $storeId,
            "module" => $module,
            "needToday" => $needToday,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  string $userPhone 用户手机号 [ require true ]
     * @param  bool $force 强制绑定 [ require false ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $userId, string $userPhone, bool $force = false, int $operateId = 0) {
        return self::getClass()->bindUser([
            "id" => $id,
            "userId" => $userId,
            "userPhone" => $userPhone,
            "force" => $force,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 解绑用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id, int $operateId) {
        return self::getClass()->unbindUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoiceId 发票ID [ require true ]
     * @param  array $orderNos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoiceId" => $invoiceId,
            "orderNos" => $orderNos,
        ]);
    }

    /**
     * 计算订单消费金额
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderConsumeMoney (int $id) {
        return self::getClass()->getOrderConsumeMoney([
            "id" => $id,
        ]);
    }

    /**
     * 查看订单操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderOperateLog (int $orderId) {
        return self::getClass()->getOrderOperateLog([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 批量查看订单操作日志
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetOrdersOperateLog (array $orderIds) {
        return self::getClass()->batchGetOrdersOperateLog([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取订单某操作记录次数
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $actions 动作组 [ require true ]
     * @param  bool $includeTransfer 是否包含转门店订单 [ require false ]
     * @param  string $from 来源 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderOperateLogCount (int $orderId, array $actions, bool $includeTransfer = false, string $from = '') {
        return self::getClass()->getOrderOperateLogCount([
            "orderId" => $orderId,
            "actions" => $actions,
            "includeTransfer" => $includeTransfer,
            "from" => $from,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $userName 用户姓名 [ require false ]
     * @param  string $userSex 用户性别 [ require false ]
     * @param  string $userEmail 用户邮箱 [ require false ]
     * @param  string $userBirthday 用户生日 [ require false ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData (int $id, string $userName = null, string $userSex = null, string $userEmail = null, string $userBirthday = null, int $operateId = 0) {
        return self::getClass()->changeUserData([
            "id" => $id,
            "userName" => $userName,
            "userSex" => $userSex,
            "userEmail" => $userEmail,
            "userBirthday" => $userBirthday,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 转门店只有没有二销的才可以，只会转一销
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  int $occupyNum 排单表占点数量 [ require false ]
     * @param  array $occupyIndexs 排单表占点位置 [ require false ]
     * @param  bool $setReservation 是否需要订单设置排单表信息 [ require false ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  string $from 来源(&#039;pc&#039;,&#039;mobile&#039;) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStore (int $id, int $storeId, string $reserveTime, int $operateId, int $occupyNum = 0, string $from = 'pc', array $occupyIndexs = [], bool $setReservation = true) {
        return self::getClass()->changeStore([
            "id" => $id,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
            "occupyNum" => $occupyNum,
            "from" => $from,
            "occupyIndexs" => $occupyIndexs,
            "setReservation" => $setReservation,
        ]);
    }

    /**
     * 【缦图使用】
     *
     * @param  int $dsModel 查询类型 1：共享 2：主推 [ require false ]
     * @param  int $staffId 伙伴id [ require true ]
     * @param  int $storeId 门店id [ require false ]
     * @param  bool $withUpgrade 包含升级服务 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryDsListWithStore (int $staffId, string $startTime, string $endTime, int $dsModel = 2, int $storeId = 0, bool $withUpgrade = true, int $page = 1, int $pageSize = 10) {
        return self::getClass()->queryDsListWithStore([
            "staffId" => $staffId,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "dsModel" => $dsModel,
            "storeId" => $storeId,
            "withUpgrade" => $withUpgrade,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     *
     * @param  string $orderNo 订单号 [ require false ]
     * @param  int $orderId 订单ID [ require false ]
     * @param  int $orderSaleId 订单ID [ require false ]
     * @param  bool $withDeleted 是否需要已删除的数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (string $orderNo = '', int $orderId = 0, int $orderSaleId = null, bool $withDeleted = false) {
        return self::getClass()->getProductsInOrder([
            "orderNo" => $orderNo,
            "orderId" => $orderId,
            "orderSaleId" => $orderSaleId,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  array $orderIds 订单ID数组 [ require false ]
     * @param  bool $withDeleted 是否需要已删除的数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrders (array $orderNos = [], array $orderIds = [], bool $withDeleted = false) {
        return self::getClass()->getProductsInOrders([
            "orderNos" => $orderNos,
            "orderIds" => $orderIds,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * 到店人数在签到接口
     *
     * @support  int $id 订单ID [ require false ]
     * @support  string $note 门店操作的订单备注，非业务备注 [ require false ]
     * @support  string $noPaperNote 无纸化备注 [ require false ]
     * @support  int $modifyCount 修改次数 [ require false ]
     * @support  int $operateId 录单人 [ require true ]
     * @support  string $partRefundTime 部分退款时间 [ require false ]
     * @support  string $appointLookPhotoSource 预约看片来源 user 用户预约端 store 门店端 [ require false ]
     * @support  string $outsideCity 外拍订单城市 [ require false ]
     * @support  string $outsideAddress 外拍订单地址 [ require false ]
     * @support  string $groupName 无纸化分组名称 [ require false ]
     * @support  int $groupId 无纸化分组id [ require false ]
     * @support  string $paperlessNote 无纸化备注 [ require false ]
     * @support  string $firstWatchFinishType 第一次订单看片完成类型 [ require false ]
     * @support  array $sendMemberCoupons 发送会员优惠券 [ require false ]
     * @support  array $birthGiftInfo 生日礼遇领取信息 [ require false ]
     * @support  array $newYearWishInfo 新年许愿信息 [ require false ]
     * @support  string $discountNote 优惠备注 [ require false ]
     * @support  string $stageName 花名 [ require false ]
     * @support  string $weddingDay 结婚婚期 [ require false ]
     * @support  string $mantuSpecialTag 缦图标签 [ require false ]
     * @support  string $mantuJoinTime 加入时间 [ require false ]
     * @support  string $mantuChannel 缦图渠道 [ require false ]
     * @support  array $peoplePhotos 拍摄成员信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeExtend () {
        return self::getClass()->changeExtend([
        ]);
    }

    /**
     * 设置拍摄订单签到
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $reachedPeopleNum 签到人数 [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @param  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @param  float $money 签到补收金额（如果不需要补收，可以为空） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0.0) {
        return self::getClass()->userReached([
            "orderId" => $orderId,
            "reachedPeopleNum" => $reachedPeopleNum,
            "inputStaffId" => $inputStaffId,
            "needMoney" => $needMoney,
            "money" => $money,
        ]);
    }

    /**
     * 如果没有数据，说明没有支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserReachedDetail (int $orderId) {
        return self::getClass()->getUserReachedDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改拍摄订单签到
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $reachedPeopleNum 签到人数 [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @param  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @param  float $money 签到补收金额（如果不需要补收，可以为空），减去原先已经支付的签到金额 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyUserReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0.0) {
        return self::getClass()->modifyUserReached([
            "orderId" => $orderId,
            "reachedPeopleNum" => $reachedPeopleNum,
            "inputStaffId" => $inputStaffId,
            "needMoney" => $needMoney,
            "money" => $money,
        ]);
    }

    /**
     * 只能操作未支付的拍摄签到订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelUserReached (int $orderId, int $orderDiffId, int $inputStaffId, string $reason) {
        return self::getClass()->cancelUserReached([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "inputStaffId" => $inputStaffId,
            "reason" => $reason,
        ]);
    }

    /**
     * 如果不需要补收金额，不用调该接口
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @param  int $operateId 录单人 [ require false ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->setUserReachedPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * 获取门店订单完成数量
     *
     * @param  string $startDate 查询开始时间 [ require true ]
     * @param  string $endDate 查询结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreFinishOrderCount (string $startDate, string $endDate) {
        return self::getClass()->getStoreFinishOrderCount([
            "startDate" => $startDate,
            "endDate" => $endDate,
        ]);
    }

    /**
     * 设置订单的无纸化完成
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderPaperlessFinish (int $id) {
        return self::getClass()->setOrderPaperlessFinish([
            "id" => $id,
        ]);
    }

    /**
     * storeId,userId,userPhone,orderId,orderIds,orderNo,orderNos必须要有一个值存在
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @support  string $userPhone 用户手机号 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  array $orderIds 订单ids [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态列表 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  array $typeList 批量获取订单类型 [ require false ]
     * @support  string $module 订单模块 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  array $sortEnums 排序枚举（订单状态） [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  bool $hasBeenInvoiced 是否已开发票 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvoiceList () {
        return self::getClass()->getInvoiceList([
        ]);
    }

    /**
     * storeId,userId,userPhone,orderId,orderIds,orderNo,orderNos必须要有一个值存在
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @support  string $userPhone 用户手机号 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  array $orderIds 订单ids [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态列表 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  array $typeList 批量获取订单类型 [ require false ]
     * @support  string $module 订单模块 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  array $sortEnums 排序枚举（订单状态） [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $hasBeenInvoiced 是否已开发票 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvoiceAll () {
        return self::getClass()->getInvoiceAll([
        ]);
    }

    /**
     * 获取上个月门店订单完成数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreOrderCount () {
        return self::getClass()->getStoreOrderCount();
    }

    /**
     * 根据看片时间获取未设置完成服务的拍摄产品
     *
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  string $orderType 订单类型: order: 订单 upgrade:升级服务 [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderUnSetServiceComplete () {
        return self::getClass()->getOrderUnSetServiceComplete([
        ]);
    }

    /**
     * 查询订单编号
     *
     * @support  array $storeIds 门店ids [ require false ]
     * @support  array $productIds 产品ids [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  int $userId 绑定用户uid [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchOrderNo () {
        return self::getClass()->searchOrderNo([
        ]);
    }

    /**
     * 获取预约看片信息
     *
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  int $page 分页 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderLookPhotoReserveLit () {
        return self::getClass()->getOrderLookPhotoReserveLit([
        ]);
    }

    /**
     * 根据订单Ids批量获取订单号
     *
     * @param  array $ids 订单IDs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderNosByIds (array $ids) {
        return self::getClass()->getOrderNosByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取订单的拍摄产品和升级服务产品
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  array $orderIds 订单ids [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderSaleSkuAndUpgradeSku () {
        return self::getClass()->getOrderSaleSkuAndUpgradeSku([
        ]);
    }

    /**
     * 获取订单是否绑定用户
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isBindUser (int $id) {
        return self::getClass()->isBindUser([
            "id" => $id,
        ]);
    }

    /**
     * 当订单状态未值时，会默认只取已支付的订单： wait_shooting,working,finished,service_completed
     *
     * @support  int $userId 用户id [ require false ]
     * @support  array $productIds 拍摄产品s [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductOrders () {
        return self::getClass()->getProductOrders([
        ]);
    }

    /**
     * 当订单状态未值时，会默认只取已支付的订单： wait_shooting,working,finished,service_completed
     *
     * @support  int $userId 用户id [ require false ]
     * @support  array $productIds 拍摄产品s [ require true ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductOrderList () {
        return self::getClass()->getProductOrderList([
        ]);
    }

    /**
     * 查询订单及其所有的拍摄产品信息
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $origin 订单来源:mobile,pc [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  array $neqStatusList 不包含的订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrdersWithAllSkus () {
        return self::getClass()->searchOrdersWithAllSkus([
        ]);
    }

    /**
     * 查询订单及其所有的拍摄产品信息——使用db
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $notInOrderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  bool $withRefund 是否包含已经关闭的订单 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrdersWithAllSkusUseDb () {
        return self::getClass()->searchOrdersWithAllSkusUseDb([
        ]);
    }

    /**
     * 转门店带零售订单
     *
     * @param  int $orderId 原订单id [ require true ]
     * @param  int $newStoreId 新门店id [ require true ]
     * @param  int $newOrderId 新订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retailOrderHookChangeStore (int $orderId, int $newStoreId, int $newOrderId) {
        return self::getClass()->retailOrderHookChangeStore([
            "orderId" => $orderId,
            "newStoreId" => $newStoreId,
            "newOrderId" => $newOrderId,
        ]);
    }

    /**
     * 查询订单以及拍摄产品信息
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $origin 订单来源:mobile,pc [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  array $neqStatusList 不包含的订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  bool $withModifyClosed 是否包含已经关闭的订单 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrderWithSku () {
        return self::getClass()->searchOrderWithSku([
        ]);
    }

    /**
     * 获取用户可开发票的门店列表
     *
     * @support  int $userId 用户id [ require false ]
     * @support  string $userPhone 用户手机号 [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态列表 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  array $typeList 批量获取订单类型 [ require false ]
     * @support  string $module 订单模块 [ require false ]
     * @support  bool $hasBeenInvoiced 是否已开发票 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInvoiceStoreList () {
        return self::getClass()->getUserInvoiceStoreList([
        ]);
    }

    /**
     * 获取用户订单所在门店
     *
     * @param  int $userId 用户id [ require true ]
     * @param  array $statusList 订单状态 [ require false ]
     * @param  bool $withDel 是否需要删除数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStoreIdsByUserId (int $userId, array $statusList = [], bool $withDel = false) {
        return self::getClass()->getOrderStoreIdsByUserId([
            "userId" => $userId,
            "statusList" => $statusList,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 获取用户已开票订单
     *
     * @param  int $userId 用户id [ require true ]
     * @param  array $statusList 订单状态 [ require false ]
     * @param  string $module 订单module [ require false ]
     * @param  bool $withDel 是否需要删除数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAlreadyInvoiceOrderByUserId (int $userId, array $statusList = [], string $module = 'himo', bool $withDel = false) {
        return self::getClass()->getAlreadyInvoiceOrderByUserId([
            "userId" => $userId,
            "statusList" => $statusList,
            "module" => $module,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 批量查询订单基础信息
     *
     * @support  array $orderIds 订单ids [ require false ]
     * @support  array $orderNos 订单编号s [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  string $origin 订单来源:mobile,pc [ require false ]
     * @support  string $reserveTimeStart 预约开始时间 [ require false ]
     * @support  string $reserveTimeEnd 预约结束时间 [ require false ]
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 [ require false ]
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 [ require false ]
     * @support  string $createTimeStart 查询开始时间 [ require false ]
     * @support  string $createTimeEnd 查询结束时间 [ require false ]
     * @support  string $lookPhotoTimeStart 看片完成开始时间 [ require false ]
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 [ require false ]
     * @support  array $userIds 绑定用户uids [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  array $statusList 订单状态 [ require false ]
     * @support  array $neqStatusList 不包含的订单状态 [ require false ]
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 [ require false ]
     * @support  string $userName 下单用户 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  string $type 订单类型 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  bool $withDel 是否需要删除数据 [ require false ]
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 [ require false ]
     * @support  bool $withSku 是否需要购买产品详情 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchOrderBasic () {
        return self::getClass()->searchOrderBasic([
        ]);
    }

    /**
     * 设置学生会员信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $studentMembership 是否是学生会员 [ require true ]
     * @param  bool $forcedRefresh 强制更新 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStudentMembership (int $orderId, string $studentMembership, bool $forcedRefresh = false) {
        return self::getClass()->setStudentMembership([
            "orderId" => $orderId,
            "studentMembership" => $studentMembership,
            "forcedRefresh" => $forcedRefresh,
        ]);
    }

    /**
     * 清除学生会员信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanStudentMembership (int $orderId, int $operateId) {
        return self::getClass()->cleanStudentMembership([
            "orderId" => $orderId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单基础详情
     *
     * @support  int $id 订单ID [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  bool $withDelete 是否包含删除的订单 [ require false ]
     * @support  bool $withSku 是否包含拍摄产品 [ require false ]
     * @support  bool $withModifyRefundSku 拍摄产品是否需要转退信息 [ require false ]
     * @support  bool $withTurnover 是否包含已经关闭的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderBasicDetail () {
        return self::getClass()->orderBasicDetail([
        ]);
    }

    /**
     * 如果尾款支付金额为负数，则只能操作一次
     *
     * @param  int $id 订单ID [ require true ]
     * @param  float $paidMoney 支付的尾款金额 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createOrderBalancePayment (int $id, float $paidMoney, int $operateId) {
        return self::getClass()->createOrderBalancePayment([
            "id" => $id,
            "paidMoney" => $paidMoney,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 团购订单支付
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @param  array $groupOrderItemIds 团购拍摄产品信息 [ require true ]
     * @param  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function groupOrderPaid (int $orderId, int $orderDiffId, array $groupOrderItemIds, int $inputStaffId) {
        return self::getClass()->groupOrderPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "groupOrderItemIds" => $groupOrderItemIds,
            "inputStaffId" => $inputStaffId,
        ]);
    }

    /**
     * 获取订单的拍摄人数信息
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @param  array $orderNos 订单编号s [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderPeoples (array $orderIds, array $orderNos) {
        return self::getClass()->orderPeoples([
            "orderIds" => $orderIds,
            "orderNos" => $orderNos,
        ]);
    }

    /**
     * 设置照片交付时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $photoFinishedAt 照片交付时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPhotoFinishedAt (int $orderId, string $photoFinishedAt = null) {
        return self::getClass()->setPhotoFinishedAt([
            "orderId" => $orderId,
            "photoFinishedAt" => $photoFinishedAt,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}