<?php
namespace Mainto\Bridge\Enums\Order\Order;

class OrderChannelEnum {
    const WECHAT = 'wechat';
    const WX_MINI_PROGRAM = 'wx_mini_program';
    const ALIPAY_MINI_PROGRAM = 'alipay_mini_program';
    const IOS = 'ios';
    const ANDROID = 'android';
    const WX_APP = 'wx_app';
    const STORE = 'store';
    const STORE_GROUP = 'store_group';
    /**
     * 门店端——个人拍摄（未使用）
     */
    const STORE_PERSON_ORDER = 'store_person_order';
    /**
     * family外拍订单
     */
    const OUTSIDE_ORDER = 'outside_order';
    const BMS = 'bms';
    /**
     * bms——个人拍摄（未使用）
     */
    const BMS_PERSON_ORDER = 'bms_person_order';
    /**
     * 总部录单（未使用）
     */
    const HEADQUARTERS_ORDER = 'headquarters_order';
    /**
     * Business订单
     */
    const BUSINESS_ORDER = 'business_order';
    /**
     * Business外拍订单
     */
    const BUSINESS_OUTSIDE_ORDER = 'business_outside_order';
    const CRM_ACTIVITY = 'crm_activity';
    const MEITUAN_DIANPING = 'meituan_dianping';
    const DIANPING_TUANGOU = 'dianping_tuangou';
    const DOUYIN = 'douyin';
    /**
     * 百度糯米（老数据）
     */
    const NUOMI = 'nuomi';
    /**
     * 口碑（老数据）
     */
    const KOUBEI = 'koubei';
    const KOC_KOL = 'koc_kol';
    /**
     * 未知来源，用于区分已修复和未修复
     */
    const UNDEFINED = 'undefined';
    /**
     * 所有下单平台
     */
    const ALL_CHANNEL_MAP = [0 => 'wechat',1 => 'wx_mini_program',2 => 'alipay_mini_program',3 => 'ios',4 => 'android',5 => 'wx_app',6 => 'store',7 => 'bms',8 => 'meituan_dianping',9 => 'crm_activity',10 => 'store_person_order',11 => 'store_group',12 => 'outside_order',13 => 'bms_person_order',14 => 'headquarters_order',15 => 'business_order',16 => 'business_outside_order',17 => 'dianping_tuangou',18 => 'douyin',19 => 'koc_kol'];
}