<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method createByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method removeByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method allIncomeItemsByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method changePayTypeByParams(array $params)
 */
class OfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $status_list 状态列表 [ require false ]
     * @support  int $store_id 门店ID [ require false ]
     * @support  array $store_id_list 门店列表 [ require false ]
     * @support  int $item_id 收入项id [ require false ]
     * @support  string $paid_at_start 支付时间起始 [ require false ]
     * @support  string $paid_at_end 支付时间结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 线下订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 线下订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByNo (string $order_no) {
        return self::getClass()->detailByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  float $money 订单金额 [ require true ]
     * @support  int $incomeItemId 线下收入项目ID [ require true ]
     * @support  array $childItemNums 子项目id数量 [ require false ]
     * @support  int $amount 数量 [ require true ]
     * @support  string $note 备注 [ require false ]
     * @support  array $coupon_ids 券码id [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @support  string $serviceTime 服务时间 [ require false ]
     * @support  array $print_nums 打印数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 移除订单
     *
     * @param  int $id 线下订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 线下订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @param  float $payMoney 支付金额 [ require false ]
     * @param  string $dianpingCouponCode 点评券码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = '', float $payMoney = null, string $dianpingCouponCode = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "payMoney" => $payMoney,
            "dianpingCouponCode" => $dianpingCouponCode,
        ]);
    }

    /**
     * 全部收入项目
     *
     * @param  bool $withHidden 是否包含隐藏的收入项 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allIncomeItems (bool $withHidden = false) {
        return self::getClass()->allIncomeItems([
            "withHidden" => $withHidden,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @param  array $order_nos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoice_id" => $invoice_id,
            "order_nos" => $order_nos,
        ]);
    }

    /**
     * 修改支付方式
     *
     * @param  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @support  array $extend 扩展信息[操作人信息] [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType (int $id) {
        return self::getClass()->changePayType([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}