<?php
namespace Mainto\Bridge\Structs\Order\Refund\Command\CreateRefund;

class CreateRefundCommand {
    /**
     * @var  int
     */
    public int $orderId;
    /**
     * @var  string
     */
    public string $refundType = 'part_refund';
    /**
     * @var  string
     */
    public string $refundMoneyType = 'normal';
    /**
     * @var  null|float // origin: double
     */
    public ?float $refundMoney = null;
    /**
     * @var  bool
     */
    public bool $withAmountRange = true;
    /**
     * @var  int
     */
    public int $scale = 100;
    /**
     * @var  string
     */
    public string $people;
    /**
     * @var  string
     */
    public string $account;
    /**
     * @var  string
     */
    public string $reason;
    /**
     * @var  null|array
     */
    public ?array $reasonIds = [];
    /**
     * @var  null|string
     */
    public ?string $note = null;
    /**
     * @var  int
     */
    public int $inputStaffId;
    /**
     * @var  string
     */
    public string $from;
    /**
     * @var  bool
     */
    public bool $withDelete = false;
    /**
     * @var  bool
     */
    public bool $isFastRefund = false;
    /**
     * @var  \Mainto\Bridge\Structs\Order\Refund\Command\Common\RefundInfoCommand[]
     */
    public array $refundInfo;
    /**
     * @var  null|array
     */
    public ?array $extend = [];
}