<?php
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReasonsByParams(array $params)
 * @method getUserStatisticsByParams(array $params)
 * @method getStoreStatisticsByParams(array $params)
 * @method getOrderStatisticsByParams(array $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $params)
 * @method detailByParams(array $params)
 * @method createEvaluationByParams(array|\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $params)
 * @method isAlreadyCreateAfterSaleByParams(array $params)
 * @method getAfterSaleByOrderIdByParams(array $params)
 * @method getAfterSaleByProcessInstanceIdByParams(array $params)
 * @method getAfterSaleSumInfoByParams(array $params)
 * @method allByParams(array|\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取补偿申请原因
     *
     * @param  string $type 售后单类型 [ require false ]
     * @param  bool $withDel 是否需要已删除 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ReasonTreeDTO[]
     */
    public static function getReasons (string $type = 'preferential', bool $withDel = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReasons([
                            "type" => $type,
                            "withDel" => $withDel,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ReasonTreeDTO[]"
        );
    }

    /**
     * 获取用户售后统计数据
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO
     */
    public static function getUserStatistics (int $userId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserStatistics([
                            "userId" => $userId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\UserStatisticsDTO"
        );
    }

    /**
     * 获取门店售后统计数据
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO
     */
    public static function getStoreStatistics (int $storeId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreStatistics([
                            "storeId" => $storeId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\StoreStatisticsDTO"
        );
    }

    /**
     * 获取订单售后统计数据
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOrderStatistics (int $orderId, string $type = 'preferential') {
        return self::getClass()->getOrderStatistics([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 提交售后申请单
     *
     * @var  \Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $createCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
     */
    public static function create (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateCommand $createCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($createCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }


    /**
     * 更新售后单状态
     *
     * @var  \Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $updateCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
     */
    public static function update (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\UpdateCommand $updateCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->update($updateCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }


    /**
     * 获取售后单详情
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }

    /**
     * 售后评价
     *
     * @var  \Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $createEvalutionCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO
     */
    public static function createEvaluation (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\CreateEvalutionCommand $createEvalutionCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createEvaluation($createEvalutionCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\EvaluationDTO"
        );
    }


    /**
     * 售后单列表
     *
     * @var  \Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $listCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\ListCommand $listCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($listCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\ListDTO"
        );
    }


    /**
     * 判断是否已存在售后单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isAlreadyCreateAfterSale (int $orderId, string $type = 'preferential') {
        return self::getClass()->isAlreadyCreateAfterSale([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 使用海马体订单查询存在的售后单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
     */
    public static function getAfterSaleByOrderId (int $orderId, string $type = 'preferential') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAfterSaleByOrderId([
                            "orderId" => $orderId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }

    /**
     * 通过审批实例id获取售后单信息
     *
     * @param  string $processInstanceId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @param  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO
     */
    public static function getAfterSaleByProcessInstanceId (string $processInstanceId, string $status = null, string $type = null) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAfterSaleByProcessInstanceId([
                            "processInstanceId" => $processInstanceId,
                            "status" => $status,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO"
        );
    }

    /**
     * 使用海马体订单查询已申请的售后单汇总信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require false ]
     * @param  array $statusArr 状态 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO
     */
    public static function getAfterSaleSumInfo (int $orderId, string $type = 'preferential', array $statusArr = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAfterSaleSumInfo([
                            "orderId" => $orderId,
                            "type" => $type,
                            "statusArr" => $statusArr,
                        ]),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderSumDTO"
        );
    }

    /**
     * 根据订单ids查询售后单
     *
     * @var  \Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $allCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO[]
     */
    public static function all (\Mainto\Bridge\Structs\Order\AfterSaleOrder\Command\AllCommand $allCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all($allCommand),
            "\Mainto\Bridge\Structs\Order\AfterSaleOrder\DTO\AfterSaleOrderDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}