<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotfixJxjyByParams(array $params)
 * @method hotfixOrderServiceCompleteByParams(array $params)
 * @method hotfixUserOrderServiceCompleteByParams(array $params)
 * @method hotfixSetOrderPaidByParams(array $params)
 * @method batchLookPhotoByParams(array $params)
 * @method batchOrderServiceCompleteByParams(array $params)
 * @method repairCancelReserveByParams(array $params)
 * @method syncToOrderOperateByParams(array $params)
 * @method refundCouponByParams(array $params)
 * @method closeSubmittedOrderByParams(array $params)
 * @method closeOrderReserveAndPaperlessCloseByParams(array $params)
 * @method monitorOrderEsByParams(array $params)
 */
class HotfixOrderV4 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修复加修加印的接口
     *
     * @support  int $orderSaleSkuId 拍摄产品id [ require false ]
     * @support  int $orderUpgradeSkuId 升级服务的id [ require false ]
     * @support  int $jxjyPeopleNum 升级服务的人数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hotfixJxjy () {
        return self::getClass()->hotfixJxjy([
        ]);
    }

    /**
     * 修复订单完成服务
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  string $serviceCompletedAt 服务完成时间 [ require false ]
     * @param  string $serviceCompletedType 服务完成类型 [ require false ]
     * @param  bool $sendServiceCompleteMessage 是否发送订单信息通知 [ require false ]
     * @param  bool $useNpsAt 是否使用nps信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixOrderServiceComplete (int $orderId, string $serviceCompletedAt = null, string $serviceCompletedType = null, bool $sendServiceCompleteMessage = false, bool $useNpsAt = false) {
        return self::getClass()->hotfixOrderServiceComplete([
            "orderId" => $orderId,
            "serviceCompletedAt" => $serviceCompletedAt,
            "serviceCompletedType" => $serviceCompletedType,
            "sendServiceCompleteMessage" => $sendServiceCompleteMessage,
            "useNpsAt" => $useNpsAt,
        ]);
    }

    /**
     * 修复用户订单完成服务
     *
     * @param  int $userId 用户id [ require true ]
     * @param  bool $sendServiceCompleteMessage 是否发送订单信息通知 [ require false ]
     * @param  bool $useNpsAt 是否使用nps信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixUserOrderServiceComplete (int $userId, bool $sendServiceCompleteMessage = false, bool $useNpsAt = false) {
        return self::getClass()->hotfixUserOrderServiceComplete([
            "userId" => $userId,
            "sendServiceCompleteMessage" => $sendServiceCompleteMessage,
            "useNpsAt" => $useNpsAt,
        ]);
    }

    /**
     * 设置未支付的订单完成支付
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  bool $isFirstPaid 是否首次支付 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixSetOrderPaid (int $orderId, int $orderDiffId, string $payType, string $paymentNo, bool $isFirstPaid = true) {
        return self::getClass()->hotfixSetOrderPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "isFirstPaid" => $isFirstPaid,
        ]);
    }

    /**
     * 批量修复完成看片信息
     *
     * @param  array $lookPhotoData 完成看片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchLookPhoto (array $lookPhotoData) {
        return self::getClass()->batchLookPhoto([
            "lookPhotoData" => $lookPhotoData,
        ]);
    }

    /**
     * 批量修复完成看片信息
     *
     * @param  array $orderInfo 完成服务的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchOrderServiceComplete (array $orderInfo) {
        return self::getClass()->batchOrderServiceComplete([
            "orderInfo" => $orderInfo,
        ]);
    }

    /**
     * 修复取消排单表
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  string $type 类型 [ require false ]
     * @param  bool $forcedRefresh 是否强制更新 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function repairCancelReserve (int $orderId, string $type = 'shoot_picture', bool $forcedRefresh = false) {
        return self::getClass()->repairCancelReserve([
            "orderId" => $orderId,
            "type" => $type,
            "forcedRefresh" => $forcedRefresh,
        ]);
    }

    /**
     * 通知到DEV环境记录操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $staffId 操作人id [ require true ]
     * @param  string $action 操作类型 [ require true ]
     * @param  array $extend extend [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncToOrderOperate (int $orderId, int $staffId, string $action, array $extend = []) {
        return self::getClass()->syncToOrderOperate([
            "orderId" => $orderId,
            "staffId" => $staffId,
            "action" => $action,
            "extend" => $extend,
        ]);
    }

    /**
     * 修复退款的优惠券信息
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  int $couponId 优惠券id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundCoupon (int $orderId, int $couponId) {
        return self::getClass()->refundCoupon([
            "orderId" => $orderId,
            "couponId" => $couponId,
        ]);
    }

    /**
     * 关闭已提交订单
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  string $module 订单模块 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeSubmittedOrder (string $startAt, string $endAt, string $module = 'himo') {
        return self::getClass()->closeSubmittedOrder([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "module" => $module,
        ]);
    }

    /**
     * 关闭订单拍单表以及无纸化
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $reason 关单原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeOrderReserveAndPaperlessClose (string $orderNo, string $reason) {
        return self::getClass()->closeOrderReserveAndPaperlessClose([
            "orderNo" => $orderNo,
            "reason" => $reason,
        ]);
    }

    /**
     * 数据库最新订单创建创建和es最新订单创建时间差在3分钟以上，则通知到钉钉群
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function monitorOrderEs () {
        return self::getClass()->monitorOrderEs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'HotfixOrderV4');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'HotfixOrderV4');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}