<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method destroyByParams(array $params)
 * @method allDisburseItemsByParams(array $params)
 */
class OfflineDisburseRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  int $store_id 门店ID [ require false ]
     * @support  array $store_ids 门店ID [ require false ]
     * @support  int $goods_id 支出项ID [ require false ]
     * @support  string $start_time 起始时间 [ require false ]
     * @support  string $end_time 结束时间 [ require false ]
     * @support  string $pay_type 付款类型 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $page_size  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id 线下支出记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $item_id 支出项ID [ require true ]
     * @support  float $money 金额 [ require true ]
     * @support  string $take_people 取款人 [ require true ]
     * @support  string $pay_type 付款类型 [ require true ]
     * @support  array $certificates 凭证（图片url） [ require true ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 线下支出ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroy (int $id) {
        return self::getClass()->destroy([
            "id" => $id,
        ]);
    }

    /**
     * 系统内所有可用的支出项目，默认只返回显示状态中的
     * 数据量有限，不分页，返回全部
     *
     * @param  bool $withHidden 是否包含隐藏的支出项 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allDisburseItems (bool $withHidden = false) {
        return self::getClass()->allDisburseItems([
            "withHidden" => $withHidden,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OfflineDisburseRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OfflineDisburseRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}