<?php
namespace Mainto\Bridge\Enums\Order\Order;

class OrderItemTypeEnum {
    /**
     * 主场品
     */
    const PRODUCT = 'product';
    /**
     * 升级服务
     */
    const SERVICE = 'service';
    /**
     * 增值属性(未使用)
     */
    const PRODUCT_ATTRIBUTE = 'product_attribute';
    /**
     * 打包产品的主产品
     */
    const PACKAGE_PRODUCT = 'package_product';
    /**
     * 打包产品的sku--对标product
     */
    const PACKAGE_SKU = 'package_sku';
    /**
     * 打包产品的升级服务--对标service
     */
    const PACKAGE_SERVICE = 'package_service';
    /**
     * 增值属性(未使用)
     */
    const PACKAGE_ATTRIBUTE = 'package_attribute';
    /**
     * 签到
     */
    const REACHED = 'reached';
    /**
     * 主产品
     */
    const PRIMARY_PRODUCT = [0 => 'product',1 => 'reached',2 => 'package_product'];
    /**
     * 升级服务
     */
    const PRIMARY_SERVICE = [0 => 'service',1 => 'package_sku',2 => 'package_service'];
}